/*
 * Decompiled with CFR 0.152.
 */
package fr.paris.lutece.portal.service.template;

import fr.paris.lutece.portal.service.template.IFreeMarkerTemplateService;
import fr.paris.lutece.util.html.HtmlTemplate;
import freemarker.cache.FileTemplateLoader;
import freemarker.cache.MultiTemplateLoader;
import freemarker.cache.StringTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class AbstractFreeMarkerTemplateService
implements IFreeMarkerTemplateService {
    private static final String STRING_TEMPLATE_LOADER_NAME = "stringTemplate";
    private static final String NUMBER_FORMAT_PATTERN = "0.######";
    private static final String SETTING_DATE_FORMAT = "date_format";
    private static final List<String> _listPluginsMacros = new ArrayList<String>();
    private static final Map<String, Object> _mapSharedVariables = new HashMap<String, Object>();
    private static Map<String, Configuration> _mapConfigurations = new HashMap<String, Configuration>();
    private static String _strDefaultPath;
    private static int _nTemplateUpdateDelay;
    private static Logger _logger;

    @Override
    public void setTemplateUpdateDelay(int nTemplateUpdateDelay) {
        _nTemplateUpdateDelay = nTemplateUpdateDelay;
    }

    @Override
    public void addPluginMacros(String strFileName) {
        _listPluginsMacros.add(strFileName);
    }

    @Override
    public void setSharedVariable(String name, Object obj) {
        _mapSharedVariables.put(name, obj);
    }

    @Override
    public void init(String strTemplatePath) {
        _strDefaultPath = strTemplatePath;
    }

    @Override
    public HtmlTemplate loadTemplate(String strPath, String strTemplate) {
        return this.loadTemplate(strPath, strTemplate, null, null);
    }

    @Override
    public HtmlTemplate loadTemplate(String strPath, String strTemplate, Locale locale, Object rootMap) {
        Configuration cfg = null;
        try {
            cfg = _mapConfigurations.get(strPath);
            if (cfg == null) {
                cfg = new Configuration();
                File directory = new File(this.getAbsolutePathFromRelativePath(strPath));
                cfg.setDirectoryForTemplateLoading(directory);
                if (strPath != null && strPath.equals(_strDefaultPath)) {
                    for (String string : _listPluginsMacros) {
                        cfg.addAutoInclude(string);
                    }
                }
                for (Map.Entry entry : _mapSharedVariables.entrySet()) {
                    cfg.setSharedVariable((String)entry.getKey(), entry.getValue());
                }
                cfg.setLocalizedLookup(false);
                cfg.setNumberFormat(NUMBER_FORMAT_PATTERN);
                _mapConfigurations.put(strPath, cfg);
                cfg.setSetting(SETTING_DATE_FORMAT, this.getDefaultPattern(locale));
                cfg.setTemplateUpdateDelay(_nTemplateUpdateDelay);
            }
        }
        catch (IOException e) {
            _logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (TemplateException e) {
            throw new RuntimeException(e.getMessage());
        }
        return this.processTemplate(cfg, strTemplate, rootMap, locale);
    }

    @Override
    @Deprecated
    public HtmlTemplate loadTemplate(String strTemplateData, Locale locale, Object rootMap) {
        Configuration cfg = null;
        try {
            cfg = new Configuration();
            File directory = new File(this.getAbsolutePathFromRelativePath(_strDefaultPath));
            FileTemplateLoader ftl1 = new FileTemplateLoader(directory);
            StringTemplateLoader stringLoader = new StringTemplateLoader();
            stringLoader.putTemplate(STRING_TEMPLATE_LOADER_NAME, strTemplateData);
            TemplateLoader[] loaders = new TemplateLoader[]{ftl1, stringLoader};
            MultiTemplateLoader mtl = new MultiTemplateLoader(loaders);
            cfg.setTemplateLoader((TemplateLoader)mtl);
            for (String strFileName : _listPluginsMacros) {
                cfg.addAutoInclude(strFileName);
            }
            cfg.setLocalizedLookup(false);
            cfg.setNumberFormat(NUMBER_FORMAT_PATTERN);
            cfg.setSetting(SETTING_DATE_FORMAT, this.getDefaultPattern(locale));
            cfg.setTemplateUpdateDelay(_nTemplateUpdateDelay);
        }
        catch (IOException e) {
            _logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (TemplateException e) {
            _logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return this.processTemplate(cfg, STRING_TEMPLATE_LOADER_NAME, rootMap, locale);
    }

    @Override
    public void resetConfiguration() {
        _mapConfigurations = new HashMap<String, Configuration>();
    }

    @Override
    public void resetCache() {
        for (Configuration cfg : _mapConfigurations.values()) {
            cfg.clearTemplateCache();
        }
    }

    private HtmlTemplate processTemplate(Configuration cfg, String strTemplate, Object rootMap, Locale locale) {
        HtmlTemplate template = null;
        try {
            Template ftl = locale == null ? cfg.getTemplate(strTemplate) : cfg.getTemplate(strTemplate, locale);
            StringWriter writer = new StringWriter(1024);
            ftl.setDateFormat(this.getDefaultPattern(locale));
            ftl.process(rootMap, (Writer)writer);
            template = new HtmlTemplate(writer.toString());
        }
        catch (IOException e) {
            _logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (TemplateException e) {
            throw new RuntimeException(e.getMessage());
        }
        return template;
    }

    static {
        _logger = Logger.getLogger((String)"lutece.freemarker");
    }
}

