/*
 * Decompiled with CFR 0.152.
 */
package fr.paris.lutece.util.html;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Timestamp;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class HtmlTemplate {
    private String _strTemplate;

    public HtmlTemplate() {
    }

    public HtmlTemplate(String strTemplate) {
        this._strTemplate = strTemplate;
    }

    public HtmlTemplate(HtmlTemplate template) {
        this._strTemplate = template.getHtml();
    }

    public void load(String strFilename) throws IOException {
        String strLine;
        FileReader fr = new FileReader(strFilename);
        BufferedReader in = new BufferedReader(fr);
        this._strTemplate = "";
        while ((strLine = in.readLine()) != null) {
            this._strTemplate = this._strTemplate + strLine + "\r\n";
        }
        in.close();
    }

    public void load(InputStream is) throws IOException {
        String strLine;
        InputStreamReader fr = new InputStreamReader(is);
        BufferedReader in = new BufferedReader(fr);
        this._strTemplate = "";
        while ((strLine = in.readLine()) != null) {
            this._strTemplate = this._strTemplate + strLine + "\r\n";
        }
        in.close();
        is.close();
    }

    public String getHtml() {
        return this._strTemplate;
    }

    public void substitute(String strBookmark, String strValue) {
        this._strTemplate = HtmlTemplate.substitute(this._strTemplate, strValue, strBookmark);
    }

    public void substitute(String strBookmark, int nValue) {
        String strValue = String.valueOf(nValue);
        this.substitute(strBookmark, strValue);
    }

    public void substitute(String strBookmark, java.sql.Date date) {
        String strValue = HtmlTemplate.getDateString(date);
        this.substitute(strBookmark, strValue);
    }

    public void substitute(String strBookmark, Timestamp date) {
        String strValue = HtmlTemplate.getDateString(date);
        this.substitute(strBookmark, strValue);
    }

    private static String getDateString(Date date) {
        if (date != null) {
            SimpleDateFormat formatter = new SimpleDateFormat("dd'/'MM'/'yyyy", Locale.FRANCE);
            StringBuffer strDate = new StringBuffer();
            formatter.format(date, strDate, new FieldPosition(0));
            return strDate.toString();
        }
        return "";
    }

    private static String substitute(String strSource, String strValue, String strBookmark) {
        StringBuffer strResult = new StringBuffer();
        int nPos = strSource.indexOf(strBookmark);
        String strModifySource = strSource;
        while (nPos != -1) {
            strResult.append(strModifySource.substring(0, nPos));
            strResult.append(strValue);
            strModifySource = strModifySource.substring(nPos + strBookmark.length());
            nPos = strModifySource.indexOf(strBookmark);
        }
        strResult.append(strModifySource);
        return strResult.toString();
    }
}

