package com.alibaba.simpleEL.dialect.tiny.parser;

public enum TinyELToken {
	ABSTRACT("abstract"),
	ASSERT("assert"),
	BOOLEAN("boolean"),
	BREAK("break"),
	BYTE("byte"),
	CASE("case"),
	CATCH("catch"),
	CHAR("char"),
	CLASS("class"),
	CONST("const"),
	CONTINUE("continue"),
	DEFAULT("default"),
	DO("do"),
	DOUBLE("dobule"),
	ELSE("else"),
	ENUM("enum"),
	EXTENDS("extends"),
	FINAL("final"),
	FINALLY("finally"),
	FLOAT("float"),
	FOR("for"),
	IF("if"),
	GOTO("goto"),
	IMPLEMENTS("implements"),
	IMPORT("import"),
	INSTNACEOF("instanceof"),
	INT("int"),
	INTERFACE("interface"),
	LONG("long"),
	NATIVE("native"),
	NEW("new"),
	PACKAGE("package"),
	PRIVATE("private"),
	PROTECTED("protected"),
	PUBLIC("public"),
	RETURN("return"),
	SHORT("short"),
	STATIC("static"),
	STRICTFP("strictfp"),
	SUPER("super"),
	SWITCH("switch"),
	SYNCHRONIZED("synchronized"),
	THIS("this"),
	THROW("throw"),
	THROWS("throws"),
	TRANSIENT("transient"),
	TRY("try"),
	VOID("void"),
	VOLATILE("volatile"),
	WHILE("while"),
	
	NULL("null"),
	TRUE("true"),
	FALSE("false"),
   
	LPAREN("("),
	RPAREN(")"),
	LBRACE("{"),
	RBRACE("}"),
	LBRACKET("["),
	RBRACKET("]"),
	SEMI(";"),
	COMMA(","),
	DOT("."),
	EQ("="),
	PLUSEQ("+="),
	SUBEQ("-="),
	GT(">"),
	LT("<"),
	BANG("!"),
	TILDE("~"),
	QUES("?"),
	COLON(":"),
	COLONEQ(":="),
	EQEQ("=="),
	LTEQ("<="),
	LTEQGT("<=>"),
	LTGT("<>"),
	GTEQ(">="),
	BANGEQ("!="),
	BANGGT("!>"),
	BANGLT("!<"),
	AMPAMP("&&"),
	BARBAR("||"),
	PLUS("+"),
	PLUSPLUS("++"),
	SUB("-"),
	SUBSUB("--"),
	STAR("*"),
	SLASH("/"),
	AMP("&"),
	BAR("|"),
	CARET("^"),
	PERCENT("%"),
	LTLT("<<"),
	GTGT(">>"),
	MONKEYS_AT("@"),
	
	EOF,
	ERROR,
	IDENTIFIER,
	VARIANT,
	LITERAL_STRING,
	LITERAL_INT,
	LITERAL_FLOAT,
	LITERAL_HEX
    ;
		
    public final String name;

    TinyELToken() {
        this(null);
    }

    TinyELToken(String name) {
        this.name = name;
    }
}
