/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.nacos.endpoint;

import com.alibaba.cloud.nacos.NacosDiscoveryProperties;
import com.alibaba.cloud.nacos.NacosServiceManager;
import com.alibaba.nacos.api.naming.NamingService;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;

@Endpoint(id="nacosdiscovery")
public class NacosDiscoveryEndpoint {
    private static final Logger log = LoggerFactory.getLogger(NacosDiscoveryEndpoint.class);
    private NacosServiceManager nacosServiceManager;
    private NacosDiscoveryProperties nacosDiscoveryProperties;

    public NacosDiscoveryEndpoint(NacosServiceManager nacosServiceManager, NacosDiscoveryProperties nacosDiscoveryProperties) {
        this.nacosServiceManager = nacosServiceManager;
        this.nacosDiscoveryProperties = nacosDiscoveryProperties;
    }

    @ReadOperation
    public Map<String, Object> nacosDiscovery() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("NacosDiscoveryProperties", this.nacosDiscoveryProperties);
        NamingService namingService = this.nacosServiceManager.getNamingService(this.nacosDiscoveryProperties.getNacosProperties());
        List subscribe = Collections.emptyList();
        try {
            subscribe = namingService.getSubscribeServices();
        }
        catch (Exception e) {
            log.error("get subscribe services from nacos fail,", (Throwable)e);
        }
        result.put("subscribe", subscribe);
        return result;
    }
}

