/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.adapter.servlet;

import com.alibaba.csp.sentinel.Entry;
import com.alibaba.csp.sentinel.EntryType;
import com.alibaba.csp.sentinel.SphU;
import com.alibaba.csp.sentinel.Tracer;
import com.alibaba.csp.sentinel.adapter.servlet.callback.RequestOriginParser;
import com.alibaba.csp.sentinel.adapter.servlet.callback.UrlCleaner;
import com.alibaba.csp.sentinel.adapter.servlet.callback.WebCallbackManager;
import com.alibaba.csp.sentinel.adapter.servlet.util.FilterUtil;
import com.alibaba.csp.sentinel.context.ContextUtil;
import com.alibaba.csp.sentinel.slots.block.BlockException;
import com.alibaba.csp.sentinel.util.StringUtil;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CommonFilter
implements Filter {
    private static final String HTTP_METHOD_SPECIFY = "HTTP_METHOD_SPECIFY";
    private static final String COLON = ":";
    private boolean httpMethodSpecify = false;
    private static final String EMPTY_ORIGIN = "";

    public void init(FilterConfig filterConfig) {
        this.httpMethodSpecify = Boolean.parseBoolean(filterConfig.getInitParameter(HTTP_METHOD_SPECIFY));
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest sRequest = (HttpServletRequest)request;
        Entry urlEntry = null;
        try {
            String target = FilterUtil.filterTarget(sRequest);
            UrlCleaner urlCleaner = WebCallbackManager.getUrlCleaner();
            if (urlCleaner != null) {
                target = urlCleaner.clean(target);
            }
            if (!StringUtil.isEmpty((String)target)) {
                String origin = this.parseOrigin(sRequest);
                ContextUtil.enter((String)"sentinel_web_servlet_context", (String)origin);
                if (this.httpMethodSpecify) {
                    String pathWithHttpMethod = sRequest.getMethod().toUpperCase() + COLON + target;
                    urlEntry = SphU.entry((String)pathWithHttpMethod, (int)1, (EntryType)EntryType.IN);
                } else {
                    urlEntry = SphU.entry((String)target, (int)1, (EntryType)EntryType.IN);
                }
            }
            chain.doFilter(request, response);
        }
        catch (BlockException e) {
            HttpServletResponse sResponse = (HttpServletResponse)response;
            WebCallbackManager.getUrlBlockHandler().blocked(sRequest, sResponse, e);
        }
        catch (IOException | RuntimeException | ServletException e2) {
            Tracer.traceEntry((Throwable)e2, urlEntry);
            throw e2;
        }
        finally {
            if (urlEntry != null) {
                urlEntry.exit();
            }
            ContextUtil.exit();
        }
    }

    private String parseOrigin(HttpServletRequest request) {
        RequestOriginParser originParser = WebCallbackManager.getRequestOriginParser();
        String origin = EMPTY_ORIGIN;
        if (originParser != null && StringUtil.isEmpty((String)(origin = originParser.parseOrigin(request)))) {
            return EMPTY_ORIGIN;
        }
        return origin;
    }

    public void destroy() {
    }
}

