/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.gamelift.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * <p>
 * Represents the input for a request action.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateFleet" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class CreateFleetRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * Descriptive label that is associated with a fleet. Fleet names do not need to be unique.
     * </p>
     */
    private String name;
    /**
     * <p>
     * Human-readable description of a fleet.
     * </p>
     */
    private String description;
    /**
     * <p>
     * Unique identifier for a build to be deployed on the new fleet. The build must have been successfully uploaded to
     * Amazon GameLift and be in a <code>READY</code> status. This fleet setting cannot be changed once the fleet is
     * created.
     * </p>
     */
    private String buildId;
    /**
     * <p>
     * This parameter is no longer used. Instead, specify a server launch path using the
     * <code>RuntimeConfiguration</code> parameter. (Requests that specify a server launch path and launch parameters
     * instead of a runtime configuration will continue to work.)
     * </p>
     */
    private String serverLaunchPath;
    /**
     * <p>
     * This parameter is no longer used. Instead, specify server launch parameters in the
     * <code>RuntimeConfiguration</code> parameter. (Requests that specify a server launch path and launch parameters
     * instead of a runtime configuration will continue to work.)
     * </p>
     */
    private String serverLaunchParameters;
    /**
     * <p>
     * This parameter is no longer used. Instead, to specify where Amazon GameLift should store log files once a server
     * process shuts down, use the Amazon GameLift server API <code>ProcessReady()</code> and specify one or more
     * directory paths in <code>logParameters</code>. See more information in the <a href=
     * "http://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api-ref.html#gamelift-sdk-server-api-ref-dataypes-process"
     * >Server API Reference</a>.
     * </p>
     */
    private java.util.List<String> logPaths;
    /**
     * <p>
     * Name of an EC2 instance type that is supported in Amazon GameLift. A fleet instance type determines the computing
     * resources of each instance in the fleet, including CPU, memory, storage, and networking capacity. Amazon GameLift
     * supports the following EC2 instance types. See <a href="http://aws.amazon.com/ec2/instance-types/">Amazon EC2
     * Instance Types</a> for detailed descriptions.
     * </p>
     */
    private String eC2InstanceType;
    /**
     * <p>
     * Range of IP addresses and port settings that permit inbound traffic to access server processes running on the
     * fleet. If no inbound permissions are set, including both IP address range and port range, the server processes in
     * the fleet cannot accept connections. You can specify one or more sets of permissions for a fleet.
     * </p>
     */
    private java.util.List<IpPermission> eC2InboundPermissions;
    /**
     * <p>
     * Game session protection policy to apply to all instances in this fleet. If this parameter is not set, instances
     * in this fleet default to no protection. You can change a fleet's protection policy using UpdateFleetAttributes,
     * but this change will only affect sessions created after the policy change. You can also set protection for
     * individual instances using <a>UpdateGameSession</a>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>NoProtection</b> – The game session can be terminated during a scale-down event.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>FullProtection</b> – If the game session is in an <code>ACTIVE</code> status, it cannot be terminated during a
     * scale-down event.
     * </p>
     * </li>
     * </ul>
     */
    private String newGameSessionProtectionPolicy;
    /**
     * <p>
     * Instructions for launching server processes on each instance in the fleet. The runtime configuration for a fleet
     * has a collection of server process configurations, one for each type of server process to run on an instance. A
     * server process configuration specifies the location of the server executable, launch parameters, and the number
     * of concurrent processes with that configuration to maintain on each instance. A CreateFleet request must include
     * a runtime configuration with at least one server process configuration; otherwise the request will fail with an
     * invalid request exception. (This parameter replaces the parameters <code>ServerLaunchPath</code> and
     * <code>ServerLaunchParameters</code>; requests that contain values for these parameters instead of a runtime
     * configuration will continue to work.)
     * </p>
     */
    private RuntimeConfiguration runtimeConfiguration;
    /**
     * <p>
     * Policy that limits the number of game sessions an individual player can create over a span of time for this
     * fleet.
     * </p>
     */
    private ResourceCreationLimitPolicy resourceCreationLimitPolicy;
    /**
     * <p>
     * Names of metric groups to add this fleet to. Use an existing metric group name to add this fleet to the group, or
     * use a new name to create a new metric group. Currently, a fleet can only be included in one metric group at a
     * time.
     * </p>
     */
    private java.util.List<String> metricGroups;

    /**
     * <p>
     * Descriptive label that is associated with a fleet. Fleet names do not need to be unique.
     * </p>
     * 
     * @param name
     *        Descriptive label that is associated with a fleet. Fleet names do not need to be unique.
     */

    public void setName(String name) {
        this.name = name;
    }

    /**
     * <p>
     * Descriptive label that is associated with a fleet. Fleet names do not need to be unique.
     * </p>
     * 
     * @return Descriptive label that is associated with a fleet. Fleet names do not need to be unique.
     */

    public String getName() {
        return this.name;
    }

    /**
     * <p>
     * Descriptive label that is associated with a fleet. Fleet names do not need to be unique.
     * </p>
     * 
     * @param name
     *        Descriptive label that is associated with a fleet. Fleet names do not need to be unique.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateFleetRequest withName(String name) {
        setName(name);
        return this;
    }

    /**
     * <p>
     * Human-readable description of a fleet.
     * </p>
     * 
     * @param description
     *        Human-readable description of a fleet.
     */

    public void setDescription(String description) {
        this.description = description;
    }

    /**
     * <p>
     * Human-readable description of a fleet.
     * </p>
     * 
     * @return Human-readable description of a fleet.
     */

    public String getDescription() {
        return this.description;
    }

    /**
     * <p>
     * Human-readable description of a fleet.
     * </p>
     * 
     * @param description
     *        Human-readable description of a fleet.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateFleetRequest withDescription(String description) {
        setDescription(description);
        return this;
    }

    /**
     * <p>
     * Unique identifier for a build to be deployed on the new fleet. The build must have been successfully uploaded to
     * Amazon GameLift and be in a <code>READY</code> status. This fleet setting cannot be changed once the fleet is
     * created.
     * </p>
     * 
     * @param buildId
     *        Unique identifier for a build to be deployed on the new fleet. The build must have been successfully
     *        uploaded to Amazon GameLift and be in a <code>READY</code> status. This fleet setting cannot be changed
     *        once the fleet is created.
     */

    public void setBuildId(String buildId) {
        this.buildId = buildId;
    }

    /**
     * <p>
     * Unique identifier for a build to be deployed on the new fleet. The build must have been successfully uploaded to
     * Amazon GameLift and be in a <code>READY</code> status. This fleet setting cannot be changed once the fleet is
     * created.
     * </p>
     * 
     * @return Unique identifier for a build to be deployed on the new fleet. The build must have been successfully
     *         uploaded to Amazon GameLift and be in a <code>READY</code> status. This fleet setting cannot be changed
     *         once the fleet is created.
     */

    public String getBuildId() {
        return this.buildId;
    }

    /**
     * <p>
     * Unique identifier for a build to be deployed on the new fleet. The build must have been successfully uploaded to
     * Amazon GameLift and be in a <code>READY</code> status. This fleet setting cannot be changed once the fleet is
     * created.
     * </p>
     * 
     * @param buildId
     *        Unique identifier for a build to be deployed on the new fleet. The build must have been successfully
     *        uploaded to Amazon GameLift and be in a <code>READY</code> status. This fleet setting cannot be changed
     *        once the fleet is created.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateFleetRequest withBuildId(String buildId) {
        setBuildId(buildId);
        return this;
    }

    /**
     * <p>
     * This parameter is no longer used. Instead, specify a server launch path using the
     * <code>RuntimeConfiguration</code> parameter. (Requests that specify a server launch path and launch parameters
     * instead of a runtime configuration will continue to work.)
     * </p>
     * 
     * @param serverLaunchPath
     *        This parameter is no longer used. Instead, specify a server launch path using the
     *        <code>RuntimeConfiguration</code> parameter. (Requests that specify a server launch path and launch
     *        parameters instead of a runtime configuration will continue to work.)
     */

    public void setServerLaunchPath(String serverLaunchPath) {
        this.serverLaunchPath = serverLaunchPath;
    }

    /**
     * <p>
     * This parameter is no longer used. Instead, specify a server launch path using the
     * <code>RuntimeConfiguration</code> parameter. (Requests that specify a server launch path and launch parameters
     * instead of a runtime configuration will continue to work.)
     * </p>
     * 
     * @return This parameter is no longer used. Instead, specify a server launch path using the
     *         <code>RuntimeConfiguration</code> parameter. (Requests that specify a server launch path and launch
     *         parameters instead of a runtime configuration will continue to work.)
     */

    public String getServerLaunchPath() {
        return this.serverLaunchPath;
    }

    /**
     * <p>
     * This parameter is no longer used. Instead, specify a server launch path using the
     * <code>RuntimeConfiguration</code> parameter. (Requests that specify a server launch path and launch parameters
     * instead of a runtime configuration will continue to work.)
     * </p>
     * 
     * @param serverLaunchPath
     *        This parameter is no longer used. Instead, specify a server launch path using the
     *        <code>RuntimeConfiguration</code> parameter. (Requests that specify a server launch path and launch
     *        parameters instead of a runtime configuration will continue to work.)
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateFleetRequest withServerLaunchPath(String serverLaunchPath) {
        setServerLaunchPath(serverLaunchPath);
        return this;
    }

    /**
     * <p>
     * This parameter is no longer used. Instead, specify server launch parameters in the
     * <code>RuntimeConfiguration</code> parameter. (Requests that specify a server launch path and launch parameters
     * instead of a runtime configuration will continue to work.)
     * </p>
     * 
     * @param serverLaunchParameters
     *        This parameter is no longer used. Instead, specify server launch parameters in the
     *        <code>RuntimeConfiguration</code> parameter. (Requests that specify a server launch path and launch
     *        parameters instead of a runtime configuration will continue to work.)
     */

    public void setServerLaunchParameters(String serverLaunchParameters) {
        this.serverLaunchParameters = serverLaunchParameters;
    }

    /**
     * <p>
     * This parameter is no longer used. Instead, specify server launch parameters in the
     * <code>RuntimeConfiguration</code> parameter. (Requests that specify a server launch path and launch parameters
     * instead of a runtime configuration will continue to work.)
     * </p>
     * 
     * @return This parameter is no longer used. Instead, specify server launch parameters in the
     *         <code>RuntimeConfiguration</code> parameter. (Requests that specify a server launch path and launch
     *         parameters instead of a runtime configuration will continue to work.)
     */

    public String getServerLaunchParameters() {
        return this.serverLaunchParameters;
    }

    /**
     * <p>
     * This parameter is no longer used. Instead, specify server launch parameters in the
     * <code>RuntimeConfiguration</code> parameter. (Requests that specify a server launch path and launch parameters
     * instead of a runtime configuration will continue to work.)
     * </p>
     * 
     * @param serverLaunchParameters
     *        This parameter is no longer used. Instead, specify server launch parameters in the
     *        <code>RuntimeConfiguration</code> parameter. (Requests that specify a server launch path and launch
     *        parameters instead of a runtime configuration will continue to work.)
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateFleetRequest withServerLaunchParameters(String serverLaunchParameters) {
        setServerLaunchParameters(serverLaunchParameters);
        return this;
    }

    /**
     * <p>
     * This parameter is no longer used. Instead, to specify where Amazon GameLift should store log files once a server
     * process shuts down, use the Amazon GameLift server API <code>ProcessReady()</code> and specify one or more
     * directory paths in <code>logParameters</code>. See more information in the <a href=
     * "http://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api-ref.html#gamelift-sdk-server-api-ref-dataypes-process"
     * >Server API Reference</a>.
     * </p>
     * 
     * @return This parameter is no longer used. Instead, to specify where Amazon GameLift should store log files once a
     *         server process shuts down, use the Amazon GameLift server API <code>ProcessReady()</code> and specify one
     *         or more directory paths in <code>logParameters</code>. See more information in the <a href=
     *         "http://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api-ref.html#gamelift-sdk-server-api-ref-dataypes-process"
     *         >Server API Reference</a>.
     */

    public java.util.List<String> getLogPaths() {
        return logPaths;
    }

    /**
     * <p>
     * This parameter is no longer used. Instead, to specify where Amazon GameLift should store log files once a server
     * process shuts down, use the Amazon GameLift server API <code>ProcessReady()</code> and specify one or more
     * directory paths in <code>logParameters</code>. See more information in the <a href=
     * "http://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api-ref.html#gamelift-sdk-server-api-ref-dataypes-process"
     * >Server API Reference</a>.
     * </p>
     * 
     * @param logPaths
     *        This parameter is no longer used. Instead, to specify where Amazon GameLift should store log files once a
     *        server process shuts down, use the Amazon GameLift server API <code>ProcessReady()</code> and specify one
     *        or more directory paths in <code>logParameters</code>. See more information in the <a href=
     *        "http://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api-ref.html#gamelift-sdk-server-api-ref-dataypes-process"
     *        >Server API Reference</a>.
     */

    public void setLogPaths(java.util.Collection<String> logPaths) {
        if (logPaths == null) {
            this.logPaths = null;
            return;
        }

        this.logPaths = new java.util.ArrayList<String>(logPaths);
    }

    /**
     * <p>
     * This parameter is no longer used. Instead, to specify where Amazon GameLift should store log files once a server
     * process shuts down, use the Amazon GameLift server API <code>ProcessReady()</code> and specify one or more
     * directory paths in <code>logParameters</code>. See more information in the <a href=
     * "http://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api-ref.html#gamelift-sdk-server-api-ref-dataypes-process"
     * >Server API Reference</a>.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setLogPaths(java.util.Collection)} or {@link #withLogPaths(java.util.Collection)} if you want to override
     * the existing values.
     * </p>
     * 
     * @param logPaths
     *        This parameter is no longer used. Instead, to specify where Amazon GameLift should store log files once a
     *        server process shuts down, use the Amazon GameLift server API <code>ProcessReady()</code> and specify one
     *        or more directory paths in <code>logParameters</code>. See more information in the <a href=
     *        "http://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api-ref.html#gamelift-sdk-server-api-ref-dataypes-process"
     *        >Server API Reference</a>.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateFleetRequest withLogPaths(String... logPaths) {
        if (this.logPaths == null) {
            setLogPaths(new java.util.ArrayList<String>(logPaths.length));
        }
        for (String ele : logPaths) {
            this.logPaths.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * This parameter is no longer used. Instead, to specify where Amazon GameLift should store log files once a server
     * process shuts down, use the Amazon GameLift server API <code>ProcessReady()</code> and specify one or more
     * directory paths in <code>logParameters</code>. See more information in the <a href=
     * "http://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api-ref.html#gamelift-sdk-server-api-ref-dataypes-process"
     * >Server API Reference</a>.
     * </p>
     * 
     * @param logPaths
     *        This parameter is no longer used. Instead, to specify where Amazon GameLift should store log files once a
     *        server process shuts down, use the Amazon GameLift server API <code>ProcessReady()</code> and specify one
     *        or more directory paths in <code>logParameters</code>. See more information in the <a href=
     *        "http://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api-ref.html#gamelift-sdk-server-api-ref-dataypes-process"
     *        >Server API Reference</a>.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateFleetRequest withLogPaths(java.util.Collection<String> logPaths) {
        setLogPaths(logPaths);
        return this;
    }

    /**
     * <p>
     * Name of an EC2 instance type that is supported in Amazon GameLift. A fleet instance type determines the computing
     * resources of each instance in the fleet, including CPU, memory, storage, and networking capacity. Amazon GameLift
     * supports the following EC2 instance types. See <a href="http://aws.amazon.com/ec2/instance-types/">Amazon EC2
     * Instance Types</a> for detailed descriptions.
     * </p>
     * 
     * @param eC2InstanceType
     *        Name of an EC2 instance type that is supported in Amazon GameLift. A fleet instance type determines the
     *        computing resources of each instance in the fleet, including CPU, memory, storage, and networking
     *        capacity. Amazon GameLift supports the following EC2 instance types. See <a
     *        href="http://aws.amazon.com/ec2/instance-types/">Amazon EC2 Instance Types</a> for detailed descriptions.
     * @see EC2InstanceType
     */

    public void setEC2InstanceType(String eC2InstanceType) {
        this.eC2InstanceType = eC2InstanceType;
    }

    /**
     * <p>
     * Name of an EC2 instance type that is supported in Amazon GameLift. A fleet instance type determines the computing
     * resources of each instance in the fleet, including CPU, memory, storage, and networking capacity. Amazon GameLift
     * supports the following EC2 instance types. See <a href="http://aws.amazon.com/ec2/instance-types/">Amazon EC2
     * Instance Types</a> for detailed descriptions.
     * </p>
     * 
     * @return Name of an EC2 instance type that is supported in Amazon GameLift. A fleet instance type determines the
     *         computing resources of each instance in the fleet, including CPU, memory, storage, and networking
     *         capacity. Amazon GameLift supports the following EC2 instance types. See <a
     *         href="http://aws.amazon.com/ec2/instance-types/">Amazon EC2 Instance Types</a> for detailed descriptions.
     * @see EC2InstanceType
     */

    public String getEC2InstanceType() {
        return this.eC2InstanceType;
    }

    /**
     * <p>
     * Name of an EC2 instance type that is supported in Amazon GameLift. A fleet instance type determines the computing
     * resources of each instance in the fleet, including CPU, memory, storage, and networking capacity. Amazon GameLift
     * supports the following EC2 instance types. See <a href="http://aws.amazon.com/ec2/instance-types/">Amazon EC2
     * Instance Types</a> for detailed descriptions.
     * </p>
     * 
     * @param eC2InstanceType
     *        Name of an EC2 instance type that is supported in Amazon GameLift. A fleet instance type determines the
     *        computing resources of each instance in the fleet, including CPU, memory, storage, and networking
     *        capacity. Amazon GameLift supports the following EC2 instance types. See <a
     *        href="http://aws.amazon.com/ec2/instance-types/">Amazon EC2 Instance Types</a> for detailed descriptions.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see EC2InstanceType
     */

    public CreateFleetRequest withEC2InstanceType(String eC2InstanceType) {
        setEC2InstanceType(eC2InstanceType);
        return this;
    }

    /**
     * <p>
     * Name of an EC2 instance type that is supported in Amazon GameLift. A fleet instance type determines the computing
     * resources of each instance in the fleet, including CPU, memory, storage, and networking capacity. Amazon GameLift
     * supports the following EC2 instance types. See <a href="http://aws.amazon.com/ec2/instance-types/">Amazon EC2
     * Instance Types</a> for detailed descriptions.
     * </p>
     * 
     * @param eC2InstanceType
     *        Name of an EC2 instance type that is supported in Amazon GameLift. A fleet instance type determines the
     *        computing resources of each instance in the fleet, including CPU, memory, storage, and networking
     *        capacity. Amazon GameLift supports the following EC2 instance types. See <a
     *        href="http://aws.amazon.com/ec2/instance-types/">Amazon EC2 Instance Types</a> for detailed descriptions.
     * @see EC2InstanceType
     */

    public void setEC2InstanceType(EC2InstanceType eC2InstanceType) {
        this.eC2InstanceType = eC2InstanceType.toString();
    }

    /**
     * <p>
     * Name of an EC2 instance type that is supported in Amazon GameLift. A fleet instance type determines the computing
     * resources of each instance in the fleet, including CPU, memory, storage, and networking capacity. Amazon GameLift
     * supports the following EC2 instance types. See <a href="http://aws.amazon.com/ec2/instance-types/">Amazon EC2
     * Instance Types</a> for detailed descriptions.
     * </p>
     * 
     * @param eC2InstanceType
     *        Name of an EC2 instance type that is supported in Amazon GameLift. A fleet instance type determines the
     *        computing resources of each instance in the fleet, including CPU, memory, storage, and networking
     *        capacity. Amazon GameLift supports the following EC2 instance types. See <a
     *        href="http://aws.amazon.com/ec2/instance-types/">Amazon EC2 Instance Types</a> for detailed descriptions.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see EC2InstanceType
     */

    public CreateFleetRequest withEC2InstanceType(EC2InstanceType eC2InstanceType) {
        setEC2InstanceType(eC2InstanceType);
        return this;
    }

    /**
     * <p>
     * Range of IP addresses and port settings that permit inbound traffic to access server processes running on the
     * fleet. If no inbound permissions are set, including both IP address range and port range, the server processes in
     * the fleet cannot accept connections. You can specify one or more sets of permissions for a fleet.
     * </p>
     * 
     * @return Range of IP addresses and port settings that permit inbound traffic to access server processes running on
     *         the fleet. If no inbound permissions are set, including both IP address range and port range, the server
     *         processes in the fleet cannot accept connections. You can specify one or more sets of permissions for a
     *         fleet.
     */

    public java.util.List<IpPermission> getEC2InboundPermissions() {
        return eC2InboundPermissions;
    }

    /**
     * <p>
     * Range of IP addresses and port settings that permit inbound traffic to access server processes running on the
     * fleet. If no inbound permissions are set, including both IP address range and port range, the server processes in
     * the fleet cannot accept connections. You can specify one or more sets of permissions for a fleet.
     * </p>
     * 
     * @param eC2InboundPermissions
     *        Range of IP addresses and port settings that permit inbound traffic to access server processes running on
     *        the fleet. If no inbound permissions are set, including both IP address range and port range, the server
     *        processes in the fleet cannot accept connections. You can specify one or more sets of permissions for a
     *        fleet.
     */

    public void setEC2InboundPermissions(java.util.Collection<IpPermission> eC2InboundPermissions) {
        if (eC2InboundPermissions == null) {
            this.eC2InboundPermissions = null;
            return;
        }

        this.eC2InboundPermissions = new java.util.ArrayList<IpPermission>(eC2InboundPermissions);
    }

    /**
     * <p>
     * Range of IP addresses and port settings that permit inbound traffic to access server processes running on the
     * fleet. If no inbound permissions are set, including both IP address range and port range, the server processes in
     * the fleet cannot accept connections. You can specify one or more sets of permissions for a fleet.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setEC2InboundPermissions(java.util.Collection)} or
     * {@link #withEC2InboundPermissions(java.util.Collection)} if you want to override the existing values.
     * </p>
     * 
     * @param eC2InboundPermissions
     *        Range of IP addresses and port settings that permit inbound traffic to access server processes running on
     *        the fleet. If no inbound permissions are set, including both IP address range and port range, the server
     *        processes in the fleet cannot accept connections. You can specify one or more sets of permissions for a
     *        fleet.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateFleetRequest withEC2InboundPermissions(IpPermission... eC2InboundPermissions) {
        if (this.eC2InboundPermissions == null) {
            setEC2InboundPermissions(new java.util.ArrayList<IpPermission>(eC2InboundPermissions.length));
        }
        for (IpPermission ele : eC2InboundPermissions) {
            this.eC2InboundPermissions.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * Range of IP addresses and port settings that permit inbound traffic to access server processes running on the
     * fleet. If no inbound permissions are set, including both IP address range and port range, the server processes in
     * the fleet cannot accept connections. You can specify one or more sets of permissions for a fleet.
     * </p>
     * 
     * @param eC2InboundPermissions
     *        Range of IP addresses and port settings that permit inbound traffic to access server processes running on
     *        the fleet. If no inbound permissions are set, including both IP address range and port range, the server
     *        processes in the fleet cannot accept connections. You can specify one or more sets of permissions for a
     *        fleet.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateFleetRequest withEC2InboundPermissions(java.util.Collection<IpPermission> eC2InboundPermissions) {
        setEC2InboundPermissions(eC2InboundPermissions);
        return this;
    }

    /**
     * <p>
     * Game session protection policy to apply to all instances in this fleet. If this parameter is not set, instances
     * in this fleet default to no protection. You can change a fleet's protection policy using UpdateFleetAttributes,
     * but this change will only affect sessions created after the policy change. You can also set protection for
     * individual instances using <a>UpdateGameSession</a>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>NoProtection</b> – The game session can be terminated during a scale-down event.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>FullProtection</b> – If the game session is in an <code>ACTIVE</code> status, it cannot be terminated during a
     * scale-down event.
     * </p>
     * </li>
     * </ul>
     * 
     * @param newGameSessionProtectionPolicy
     *        Game session protection policy to apply to all instances in this fleet. If this parameter is not set,
     *        instances in this fleet default to no protection. You can change a fleet's protection policy using
     *        UpdateFleetAttributes, but this change will only affect sessions created after the policy change. You can
     *        also set protection for individual instances using <a>UpdateGameSession</a>.</p>
     *        <ul>
     *        <li>
     *        <p>
     *        <b>NoProtection</b> – The game session can be terminated during a scale-down event.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <b>FullProtection</b> – If the game session is in an <code>ACTIVE</code> status, it cannot be terminated
     *        during a scale-down event.
     *        </p>
     *        </li>
     * @see ProtectionPolicy
     */

    public void setNewGameSessionProtectionPolicy(String newGameSessionProtectionPolicy) {
        this.newGameSessionProtectionPolicy = newGameSessionProtectionPolicy;
    }

    /**
     * <p>
     * Game session protection policy to apply to all instances in this fleet. If this parameter is not set, instances
     * in this fleet default to no protection. You can change a fleet's protection policy using UpdateFleetAttributes,
     * but this change will only affect sessions created after the policy change. You can also set protection for
     * individual instances using <a>UpdateGameSession</a>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>NoProtection</b> – The game session can be terminated during a scale-down event.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>FullProtection</b> – If the game session is in an <code>ACTIVE</code> status, it cannot be terminated during a
     * scale-down event.
     * </p>
     * </li>
     * </ul>
     * 
     * @return Game session protection policy to apply to all instances in this fleet. If this parameter is not set,
     *         instances in this fleet default to no protection. You can change a fleet's protection policy using
     *         UpdateFleetAttributes, but this change will only affect sessions created after the policy change. You can
     *         also set protection for individual instances using <a>UpdateGameSession</a>.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>NoProtection</b> – The game session can be terminated during a scale-down event.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>FullProtection</b> – If the game session is in an <code>ACTIVE</code> status, it cannot be terminated
     *         during a scale-down event.
     *         </p>
     *         </li>
     * @see ProtectionPolicy
     */

    public String getNewGameSessionProtectionPolicy() {
        return this.newGameSessionProtectionPolicy;
    }

    /**
     * <p>
     * Game session protection policy to apply to all instances in this fleet. If this parameter is not set, instances
     * in this fleet default to no protection. You can change a fleet's protection policy using UpdateFleetAttributes,
     * but this change will only affect sessions created after the policy change. You can also set protection for
     * individual instances using <a>UpdateGameSession</a>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>NoProtection</b> – The game session can be terminated during a scale-down event.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>FullProtection</b> – If the game session is in an <code>ACTIVE</code> status, it cannot be terminated during a
     * scale-down event.
     * </p>
     * </li>
     * </ul>
     * 
     * @param newGameSessionProtectionPolicy
     *        Game session protection policy to apply to all instances in this fleet. If this parameter is not set,
     *        instances in this fleet default to no protection. You can change a fleet's protection policy using
     *        UpdateFleetAttributes, but this change will only affect sessions created after the policy change. You can
     *        also set protection for individual instances using <a>UpdateGameSession</a>.</p>
     *        <ul>
     *        <li>
     *        <p>
     *        <b>NoProtection</b> – The game session can be terminated during a scale-down event.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <b>FullProtection</b> – If the game session is in an <code>ACTIVE</code> status, it cannot be terminated
     *        during a scale-down event.
     *        </p>
     *        </li>
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see ProtectionPolicy
     */

    public CreateFleetRequest withNewGameSessionProtectionPolicy(String newGameSessionProtectionPolicy) {
        setNewGameSessionProtectionPolicy(newGameSessionProtectionPolicy);
        return this;
    }

    /**
     * <p>
     * Game session protection policy to apply to all instances in this fleet. If this parameter is not set, instances
     * in this fleet default to no protection. You can change a fleet's protection policy using UpdateFleetAttributes,
     * but this change will only affect sessions created after the policy change. You can also set protection for
     * individual instances using <a>UpdateGameSession</a>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>NoProtection</b> – The game session can be terminated during a scale-down event.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>FullProtection</b> – If the game session is in an <code>ACTIVE</code> status, it cannot be terminated during a
     * scale-down event.
     * </p>
     * </li>
     * </ul>
     * 
     * @param newGameSessionProtectionPolicy
     *        Game session protection policy to apply to all instances in this fleet. If this parameter is not set,
     *        instances in this fleet default to no protection. You can change a fleet's protection policy using
     *        UpdateFleetAttributes, but this change will only affect sessions created after the policy change. You can
     *        also set protection for individual instances using <a>UpdateGameSession</a>.</p>
     *        <ul>
     *        <li>
     *        <p>
     *        <b>NoProtection</b> – The game session can be terminated during a scale-down event.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <b>FullProtection</b> – If the game session is in an <code>ACTIVE</code> status, it cannot be terminated
     *        during a scale-down event.
     *        </p>
     *        </li>
     * @see ProtectionPolicy
     */

    public void setNewGameSessionProtectionPolicy(ProtectionPolicy newGameSessionProtectionPolicy) {
        this.newGameSessionProtectionPolicy = newGameSessionProtectionPolicy.toString();
    }

    /**
     * <p>
     * Game session protection policy to apply to all instances in this fleet. If this parameter is not set, instances
     * in this fleet default to no protection. You can change a fleet's protection policy using UpdateFleetAttributes,
     * but this change will only affect sessions created after the policy change. You can also set protection for
     * individual instances using <a>UpdateGameSession</a>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>NoProtection</b> – The game session can be terminated during a scale-down event.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>FullProtection</b> – If the game session is in an <code>ACTIVE</code> status, it cannot be terminated during a
     * scale-down event.
     * </p>
     * </li>
     * </ul>
     * 
     * @param newGameSessionProtectionPolicy
     *        Game session protection policy to apply to all instances in this fleet. If this parameter is not set,
     *        instances in this fleet default to no protection. You can change a fleet's protection policy using
     *        UpdateFleetAttributes, but this change will only affect sessions created after the policy change. You can
     *        also set protection for individual instances using <a>UpdateGameSession</a>.</p>
     *        <ul>
     *        <li>
     *        <p>
     *        <b>NoProtection</b> – The game session can be terminated during a scale-down event.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <b>FullProtection</b> – If the game session is in an <code>ACTIVE</code> status, it cannot be terminated
     *        during a scale-down event.
     *        </p>
     *        </li>
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see ProtectionPolicy
     */

    public CreateFleetRequest withNewGameSessionProtectionPolicy(ProtectionPolicy newGameSessionProtectionPolicy) {
        setNewGameSessionProtectionPolicy(newGameSessionProtectionPolicy);
        return this;
    }

    /**
     * <p>
     * Instructions for launching server processes on each instance in the fleet. The runtime configuration for a fleet
     * has a collection of server process configurations, one for each type of server process to run on an instance. A
     * server process configuration specifies the location of the server executable, launch parameters, and the number
     * of concurrent processes with that configuration to maintain on each instance. A CreateFleet request must include
     * a runtime configuration with at least one server process configuration; otherwise the request will fail with an
     * invalid request exception. (This parameter replaces the parameters <code>ServerLaunchPath</code> and
     * <code>ServerLaunchParameters</code>; requests that contain values for these parameters instead of a runtime
     * configuration will continue to work.)
     * </p>
     * 
     * @param runtimeConfiguration
     *        Instructions for launching server processes on each instance in the fleet. The runtime configuration for a
     *        fleet has a collection of server process configurations, one for each type of server process to run on an
     *        instance. A server process configuration specifies the location of the server executable, launch
     *        parameters, and the number of concurrent processes with that configuration to maintain on each instance. A
     *        CreateFleet request must include a runtime configuration with at least one server process configuration;
     *        otherwise the request will fail with an invalid request exception. (This parameter replaces the parameters
     *        <code>ServerLaunchPath</code> and <code>ServerLaunchParameters</code>; requests that contain values for
     *        these parameters instead of a runtime configuration will continue to work.)
     */

    public void setRuntimeConfiguration(RuntimeConfiguration runtimeConfiguration) {
        this.runtimeConfiguration = runtimeConfiguration;
    }

    /**
     * <p>
     * Instructions for launching server processes on each instance in the fleet. The runtime configuration for a fleet
     * has a collection of server process configurations, one for each type of server process to run on an instance. A
     * server process configuration specifies the location of the server executable, launch parameters, and the number
     * of concurrent processes with that configuration to maintain on each instance. A CreateFleet request must include
     * a runtime configuration with at least one server process configuration; otherwise the request will fail with an
     * invalid request exception. (This parameter replaces the parameters <code>ServerLaunchPath</code> and
     * <code>ServerLaunchParameters</code>; requests that contain values for these parameters instead of a runtime
     * configuration will continue to work.)
     * </p>
     * 
     * @return Instructions for launching server processes on each instance in the fleet. The runtime configuration for
     *         a fleet has a collection of server process configurations, one for each type of server process to run on
     *         an instance. A server process configuration specifies the location of the server executable, launch
     *         parameters, and the number of concurrent processes with that configuration to maintain on each instance.
     *         A CreateFleet request must include a runtime configuration with at least one server process
     *         configuration; otherwise the request will fail with an invalid request exception. (This parameter
     *         replaces the parameters <code>ServerLaunchPath</code> and <code>ServerLaunchParameters</code>; requests
     *         that contain values for these parameters instead of a runtime configuration will continue to work.)
     */

    public RuntimeConfiguration getRuntimeConfiguration() {
        return this.runtimeConfiguration;
    }

    /**
     * <p>
     * Instructions for launching server processes on each instance in the fleet. The runtime configuration for a fleet
     * has a collection of server process configurations, one for each type of server process to run on an instance. A
     * server process configuration specifies the location of the server executable, launch parameters, and the number
     * of concurrent processes with that configuration to maintain on each instance. A CreateFleet request must include
     * a runtime configuration with at least one server process configuration; otherwise the request will fail with an
     * invalid request exception. (This parameter replaces the parameters <code>ServerLaunchPath</code> and
     * <code>ServerLaunchParameters</code>; requests that contain values for these parameters instead of a runtime
     * configuration will continue to work.)
     * </p>
     * 
     * @param runtimeConfiguration
     *        Instructions for launching server processes on each instance in the fleet. The runtime configuration for a
     *        fleet has a collection of server process configurations, one for each type of server process to run on an
     *        instance. A server process configuration specifies the location of the server executable, launch
     *        parameters, and the number of concurrent processes with that configuration to maintain on each instance. A
     *        CreateFleet request must include a runtime configuration with at least one server process configuration;
     *        otherwise the request will fail with an invalid request exception. (This parameter replaces the parameters
     *        <code>ServerLaunchPath</code> and <code>ServerLaunchParameters</code>; requests that contain values for
     *        these parameters instead of a runtime configuration will continue to work.)
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateFleetRequest withRuntimeConfiguration(RuntimeConfiguration runtimeConfiguration) {
        setRuntimeConfiguration(runtimeConfiguration);
        return this;
    }

    /**
     * <p>
     * Policy that limits the number of game sessions an individual player can create over a span of time for this
     * fleet.
     * </p>
     * 
     * @param resourceCreationLimitPolicy
     *        Policy that limits the number of game sessions an individual player can create over a span of time for
     *        this fleet.
     */

    public void setResourceCreationLimitPolicy(ResourceCreationLimitPolicy resourceCreationLimitPolicy) {
        this.resourceCreationLimitPolicy = resourceCreationLimitPolicy;
    }

    /**
     * <p>
     * Policy that limits the number of game sessions an individual player can create over a span of time for this
     * fleet.
     * </p>
     * 
     * @return Policy that limits the number of game sessions an individual player can create over a span of time for
     *         this fleet.
     */

    public ResourceCreationLimitPolicy getResourceCreationLimitPolicy() {
        return this.resourceCreationLimitPolicy;
    }

    /**
     * <p>
     * Policy that limits the number of game sessions an individual player can create over a span of time for this
     * fleet.
     * </p>
     * 
     * @param resourceCreationLimitPolicy
     *        Policy that limits the number of game sessions an individual player can create over a span of time for
     *        this fleet.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateFleetRequest withResourceCreationLimitPolicy(ResourceCreationLimitPolicy resourceCreationLimitPolicy) {
        setResourceCreationLimitPolicy(resourceCreationLimitPolicy);
        return this;
    }

    /**
     * <p>
     * Names of metric groups to add this fleet to. Use an existing metric group name to add this fleet to the group, or
     * use a new name to create a new metric group. Currently, a fleet can only be included in one metric group at a
     * time.
     * </p>
     * 
     * @return Names of metric groups to add this fleet to. Use an existing metric group name to add this fleet to the
     *         group, or use a new name to create a new metric group. Currently, a fleet can only be included in one
     *         metric group at a time.
     */

    public java.util.List<String> getMetricGroups() {
        return metricGroups;
    }

    /**
     * <p>
     * Names of metric groups to add this fleet to. Use an existing metric group name to add this fleet to the group, or
     * use a new name to create a new metric group. Currently, a fleet can only be included in one metric group at a
     * time.
     * </p>
     * 
     * @param metricGroups
     *        Names of metric groups to add this fleet to. Use an existing metric group name to add this fleet to the
     *        group, or use a new name to create a new metric group. Currently, a fleet can only be included in one
     *        metric group at a time.
     */

    public void setMetricGroups(java.util.Collection<String> metricGroups) {
        if (metricGroups == null) {
            this.metricGroups = null;
            return;
        }

        this.metricGroups = new java.util.ArrayList<String>(metricGroups);
    }

    /**
     * <p>
     * Names of metric groups to add this fleet to. Use an existing metric group name to add this fleet to the group, or
     * use a new name to create a new metric group. Currently, a fleet can only be included in one metric group at a
     * time.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setMetricGroups(java.util.Collection)} or {@link #withMetricGroups(java.util.Collection)} if you want to
     * override the existing values.
     * </p>
     * 
     * @param metricGroups
     *        Names of metric groups to add this fleet to. Use an existing metric group name to add this fleet to the
     *        group, or use a new name to create a new metric group. Currently, a fleet can only be included in one
     *        metric group at a time.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateFleetRequest withMetricGroups(String... metricGroups) {
        if (this.metricGroups == null) {
            setMetricGroups(new java.util.ArrayList<String>(metricGroups.length));
        }
        for (String ele : metricGroups) {
            this.metricGroups.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * Names of metric groups to add this fleet to. Use an existing metric group name to add this fleet to the group, or
     * use a new name to create a new metric group. Currently, a fleet can only be included in one metric group at a
     * time.
     * </p>
     * 
     * @param metricGroups
     *        Names of metric groups to add this fleet to. Use an existing metric group name to add this fleet to the
     *        group, or use a new name to create a new metric group. Currently, a fleet can only be included in one
     *        metric group at a time.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateFleetRequest withMetricGroups(java.util.Collection<String> metricGroups) {
        setMetricGroups(metricGroups);
        return this;
    }

    /**
     * Returns a string representation of this object; useful for testing and debugging.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getName() != null)
            sb.append("Name: ").append(getName()).append(",");
        if (getDescription() != null)
            sb.append("Description: ").append(getDescription()).append(",");
        if (getBuildId() != null)
            sb.append("BuildId: ").append(getBuildId()).append(",");
        if (getServerLaunchPath() != null)
            sb.append("ServerLaunchPath: ").append(getServerLaunchPath()).append(",");
        if (getServerLaunchParameters() != null)
            sb.append("ServerLaunchParameters: ").append(getServerLaunchParameters()).append(",");
        if (getLogPaths() != null)
            sb.append("LogPaths: ").append(getLogPaths()).append(",");
        if (getEC2InstanceType() != null)
            sb.append("EC2InstanceType: ").append(getEC2InstanceType()).append(",");
        if (getEC2InboundPermissions() != null)
            sb.append("EC2InboundPermissions: ").append(getEC2InboundPermissions()).append(",");
        if (getNewGameSessionProtectionPolicy() != null)
            sb.append("NewGameSessionProtectionPolicy: ").append(getNewGameSessionProtectionPolicy()).append(",");
        if (getRuntimeConfiguration() != null)
            sb.append("RuntimeConfiguration: ").append(getRuntimeConfiguration()).append(",");
        if (getResourceCreationLimitPolicy() != null)
            sb.append("ResourceCreationLimitPolicy: ").append(getResourceCreationLimitPolicy()).append(",");
        if (getMetricGroups() != null)
            sb.append("MetricGroups: ").append(getMetricGroups());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof CreateFleetRequest == false)
            return false;
        CreateFleetRequest other = (CreateFleetRequest) obj;
        if (other.getName() == null ^ this.getName() == null)
            return false;
        if (other.getName() != null && other.getName().equals(this.getName()) == false)
            return false;
        if (other.getDescription() == null ^ this.getDescription() == null)
            return false;
        if (other.getDescription() != null && other.getDescription().equals(this.getDescription()) == false)
            return false;
        if (other.getBuildId() == null ^ this.getBuildId() == null)
            return false;
        if (other.getBuildId() != null && other.getBuildId().equals(this.getBuildId()) == false)
            return false;
        if (other.getServerLaunchPath() == null ^ this.getServerLaunchPath() == null)
            return false;
        if (other.getServerLaunchPath() != null && other.getServerLaunchPath().equals(this.getServerLaunchPath()) == false)
            return false;
        if (other.getServerLaunchParameters() == null ^ this.getServerLaunchParameters() == null)
            return false;
        if (other.getServerLaunchParameters() != null && other.getServerLaunchParameters().equals(this.getServerLaunchParameters()) == false)
            return false;
        if (other.getLogPaths() == null ^ this.getLogPaths() == null)
            return false;
        if (other.getLogPaths() != null && other.getLogPaths().equals(this.getLogPaths()) == false)
            return false;
        if (other.getEC2InstanceType() == null ^ this.getEC2InstanceType() == null)
            return false;
        if (other.getEC2InstanceType() != null && other.getEC2InstanceType().equals(this.getEC2InstanceType()) == false)
            return false;
        if (other.getEC2InboundPermissions() == null ^ this.getEC2InboundPermissions() == null)
            return false;
        if (other.getEC2InboundPermissions() != null && other.getEC2InboundPermissions().equals(this.getEC2InboundPermissions()) == false)
            return false;
        if (other.getNewGameSessionProtectionPolicy() == null ^ this.getNewGameSessionProtectionPolicy() == null)
            return false;
        if (other.getNewGameSessionProtectionPolicy() != null
                && other.getNewGameSessionProtectionPolicy().equals(this.getNewGameSessionProtectionPolicy()) == false)
            return false;
        if (other.getRuntimeConfiguration() == null ^ this.getRuntimeConfiguration() == null)
            return false;
        if (other.getRuntimeConfiguration() != null && other.getRuntimeConfiguration().equals(this.getRuntimeConfiguration()) == false)
            return false;
        if (other.getResourceCreationLimitPolicy() == null ^ this.getResourceCreationLimitPolicy() == null)
            return false;
        if (other.getResourceCreationLimitPolicy() != null && other.getResourceCreationLimitPolicy().equals(this.getResourceCreationLimitPolicy()) == false)
            return false;
        if (other.getMetricGroups() == null ^ this.getMetricGroups() == null)
            return false;
        if (other.getMetricGroups() != null && other.getMetricGroups().equals(this.getMetricGroups()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getName() == null) ? 0 : getName().hashCode());
        hashCode = prime * hashCode + ((getDescription() == null) ? 0 : getDescription().hashCode());
        hashCode = prime * hashCode + ((getBuildId() == null) ? 0 : getBuildId().hashCode());
        hashCode = prime * hashCode + ((getServerLaunchPath() == null) ? 0 : getServerLaunchPath().hashCode());
        hashCode = prime * hashCode + ((getServerLaunchParameters() == null) ? 0 : getServerLaunchParameters().hashCode());
        hashCode = prime * hashCode + ((getLogPaths() == null) ? 0 : getLogPaths().hashCode());
        hashCode = prime * hashCode + ((getEC2InstanceType() == null) ? 0 : getEC2InstanceType().hashCode());
        hashCode = prime * hashCode + ((getEC2InboundPermissions() == null) ? 0 : getEC2InboundPermissions().hashCode());
        hashCode = prime * hashCode + ((getNewGameSessionProtectionPolicy() == null) ? 0 : getNewGameSessionProtectionPolicy().hashCode());
        hashCode = prime * hashCode + ((getRuntimeConfiguration() == null) ? 0 : getRuntimeConfiguration().hashCode());
        hashCode = prime * hashCode + ((getResourceCreationLimitPolicy() == null) ? 0 : getResourceCreationLimitPolicy().hashCode());
        hashCode = prime * hashCode + ((getMetricGroups() == null) ? 0 : getMetricGroups().hashCode());
        return hashCode;
    }

    @Override
    public CreateFleetRequest clone() {
        return (CreateFleetRequest) super.clone();
    }

}
