/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

/**
 * <fullname>AWS Step Functions</fullname>
 * <p>
 * AWS Step Functions is a web service that enables you to coordinate the components of distributed applications and
 * microservices using visual workflows. You build applications from individual components that each perform a discrete
 * function, or <i>task</i>, allowing you to scale and change applications quickly. Step Functions provides a graphical
 * console to visualize the components of your application as a series of steps. It automatically triggers and tracks
 * each step, and retries when there are errors, so your application executes in order and as expected, every time. Step
 * Functions logs the state of each step, so when things do go wrong, you can diagnose and debug problems quickly.
 * </p>
 * <p>
 * Step Functions manages the operations and underlying infrastructure for you to ensure your application is available
 * at any scale. You can run tasks on the AWS cloud, on your own servers, or an any system that has access to AWS. Step
 * Functions can be accessed and used with the Step Functions console, the AWS SDKs (included with your Beta release
 * invitation email), or an HTTP API (the subject of this document).
 * </p>
 */
package com.amazonaws.services.stepfunctions;

