// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.email.implementation.models;

import com.azure.communication.email.models.EmailAddress;
import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Recipients of the email. */
@Fluent
public final class EmailRecipients {
    /*
     * Email To recipients
     */
    @JsonProperty(value = "to")
    private List<EmailAddress> to;

    /*
     * Email CC recipients
     */
    @JsonProperty(value = "cc")
    private List<EmailAddress> cc;

    /*
     * Email BCC recipients
     */
    @JsonProperty(value = "bcc")
    private List<EmailAddress> bCC;

    /** Creates an instance of EmailRecipients class. */
    public EmailRecipients() {
    }

    /**
     * Get the to property: Email To recipients.
     *
     * @return the to value.
     */
    public List<EmailAddress> getTo() {
        return this.to;
    }

    /**
     * Set the to property: Email To recipients.
     *
     * @param to the to value to set.
     * @return the EmailRecipients object itself.
     */
    public EmailRecipients setTo(List<EmailAddress> to) {
        this.to = to;
        return this;
    }

    /**
     * Get the cc property: Email CC recipients.
     *
     * @return the cc value.
     */
    public List<EmailAddress> getCc() {
        return this.cc;
    }

    /**
     * Set the cc property: Email CC recipients.
     *
     * @param cc the cc value to set.
     * @return the EmailRecipients object itself.
     */
    public EmailRecipients setCc(List<EmailAddress> cc) {
        this.cc = cc;
        return this;
    }

    /**
     * Get the bCC property: Email BCC recipients.
     *
     * @return the bCC value.
     */
    public List<EmailAddress> getBCC() {
        return this.bCC;
    }

    /**
     * Set the bCC property: Email BCC recipients.
     *
     * @param bCC the bCC value to set.
     * @return the EmailRecipients object itself.
     */
    public EmailRecipients setBCC(List<EmailAddress> bCC) {
        this.bCC = bCC;
        return this;
    }
}
