/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.Header;
import com.azure.core.util.MetricsOptions;
import com.azure.core.util.TracingOptions;
import com.azure.core.util.logging.ClientLogger;
import java.util.Collections;

public class ClientOptions {
    private static final int MAX_APPLICATION_ID_LENGTH = 24;
    private static final String INVALID_APPLICATION_ID_LENGTH = "'applicationId' length cannot be greater than 24";
    private static final String INVALID_APPLICATION_ID_SPACE = "'applicationId' cannot contain spaces.";
    private static final ClientLogger LOGGER = new ClientLogger(ClientOptions.class);
    private Iterable<Header> headers;
    private String applicationId;
    private MetricsOptions metricsOptions;
    private TracingOptions tracingOptions;

    public String getApplicationId() {
        return this.applicationId;
    }

    public ClientOptions setApplicationId(String applicationId) {
        if (!CoreUtils.isNullOrEmpty(applicationId)) {
            if (applicationId.length() > 24) {
                throw LOGGER.logExceptionAsError(new IllegalArgumentException(INVALID_APPLICATION_ID_LENGTH));
            }
            if (applicationId.contains(" ")) {
                throw LOGGER.logExceptionAsError(new IllegalArgumentException(INVALID_APPLICATION_ID_SPACE));
            }
        }
        this.applicationId = applicationId;
        return this;
    }

    public ClientOptions setHeaders(Iterable<Header> headers) {
        this.headers = headers;
        return this;
    }

    public Iterable<Header> getHeaders() {
        if (this.headers == null) {
            return Collections.emptyList();
        }
        return this.headers;
    }

    public ClientOptions setMetricsOptions(MetricsOptions metricsOptions) {
        this.metricsOptions = metricsOptions;
        return this;
    }

    public MetricsOptions getMetricsOptions() {
        return this.metricsOptions;
    }

    public ClientOptions setTracingOptions(TracingOptions tracingOptions) {
        this.tracingOptions = tracingOptions;
        return this;
    }

    public TracingOptions getTracingOptions() {
        return this.tracingOptions;
    }
}

