/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.implementation.aadb2c.configuration.properties;

import com.azure.spring.cloud.autoconfigure.implementation.aadb2c.configuration.properties.AadB2cCredentialProperties;
import com.azure.spring.cloud.autoconfigure.implementation.aadb2c.configuration.properties.AadB2cProfileProperties;
import com.azure.spring.cloud.autoconfigure.implementation.aadb2c.configuration.properties.AuthorizationClientProperties;
import com.azure.spring.cloud.autoconfigure.implementation.aadb2c.security.exception.AadB2cConfigurationException;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class AadB2cProperties
implements InitializingBean {
    public static final String DEFAULT_LOGOUT_SUCCESS_URL = "http://localhost:8080/login";
    public static final String PREFIX = "spring.cloud.azure.active-directory.b2c";
    public static final String DEFAULT_KEY_SIGN_UP_OR_SIGN_IN = "sign-up-or-sign-in";
    protected static final String DEFAULT_KEY_PASSWORD_RESET = "password-reset";
    @NestedConfigurationProperty
    private final AadB2cProfileProperties profile = new AadB2cProfileProperties();
    @NestedConfigurationProperty
    private final AadB2cCredentialProperties credential = new AadB2cCredentialProperties();
    private String appIdUri;
    @Deprecated
    private Duration jwtConnectTimeout = Duration.ofMillis(500L);
    @Deprecated
    private Duration jwtReadTimeout = Duration.ofMillis(500L);
    @Deprecated
    private int jwtSizeLimit = 51200;
    private String logoutSuccessUrl = "http://localhost:8080/login";
    private final Map<String, Object> authenticateAdditionalParameters = new HashMap<String, Object>();
    private String userNameAttributeName;
    private String replyUrl = "{baseUrl}/login/oauth2/code/";
    private String baseUri;
    private String loginFlow = "sign-up-or-sign-in";
    private Map<String, String> userFlows = new HashMap<String, String>();
    private final Map<String, AuthorizationClientProperties> authorizationClients = new HashMap<String, AuthorizationClientProperties>();

    public void afterPropertiesSet() {
        this.validateURLProperties();
        this.validateWebappProperties();
        this.validateCommonProperties();
    }

    private void validateWebappProperties() {
        if (!CollectionUtils.isEmpty(this.userFlows)) {
            if (!StringUtils.hasText((String)this.baseUri)) {
                throw new AadB2cConfigurationException("'baseUri' must be configured.");
            }
            if (!this.userFlows.containsKey(this.loginFlow)) {
                throw new AadB2cConfigurationException("Sign in user flow key '" + this.loginFlow + "' is not in 'user-flows' map.");
            }
        }
    }

    private void validateCommonProperties() {
        boolean usingClientCredentialFlow = this.authorizationClients.values().stream().map(AuthorizationClientProperties::getAuthorizationGrantType).anyMatch(arg_0 -> ((AuthorizationGrantType)AuthorizationGrantType.CLIENT_CREDENTIALS).equals(arg_0));
        if (usingClientCredentialFlow && !StringUtils.hasText((String)this.profile.getTenantId())) {
            throw new AadB2cConfigurationException("'tenant-id' must be configured when using client credential flow.");
        }
    }

    private void validateURLProperties() {
        if (!AadB2cProperties.isValidUrl(this.logoutSuccessUrl)) {
            throw new AadB2cConfigurationException("logout success should be valid URL.");
        }
        if (!AadB2cProperties.isValidUrl(this.baseUri)) {
            throw new AadB2cConfigurationException("baseUri should be valid URL.");
        }
    }

    private static boolean isValidUrl(String uri) {
        if (!StringUtils.hasLength((String)uri)) {
            return true;
        }
        try {
            new URL(uri);
        }
        catch (MalformedURLException ex) {
            return false;
        }
        return true;
    }

    public String getPasswordReset() {
        return this.userFlows.entrySet().stream().filter(entry -> ((String)entry.getKey()).equalsIgnoreCase(DEFAULT_KEY_PASSWORD_RESET)).findFirst().map(Map.Entry::getValue).orElse(null);
    }

    public String getBaseUri() {
        return this.baseUri;
    }

    public void setBaseUri(String baseUri) {
        this.baseUri = baseUri;
    }

    public Map<String, String> getUserFlows() {
        return this.userFlows;
    }

    public void setUserFlows(Map<String, String> userFlows) {
        this.userFlows = userFlows;
    }

    public String getLoginFlow() {
        return this.loginFlow;
    }

    public void setLoginFlow(String loginFlow) {
        this.loginFlow = loginFlow;
    }

    public AadB2cCredentialProperties getCredential() {
        return this.credential;
    }

    public String getLogoutSuccessUrl() {
        return this.logoutSuccessUrl;
    }

    public void setLogoutSuccessUrl(String logoutSuccessUrl) {
        this.logoutSuccessUrl = logoutSuccessUrl;
    }

    public Map<String, Object> getAuthenticateAdditionalParameters() {
        return this.authenticateAdditionalParameters;
    }

    public String getUserNameAttributeName() {
        return this.userNameAttributeName;
    }

    public void setUserNameAttributeName(String userNameAttributeName) {
        this.userNameAttributeName = userNameAttributeName;
    }

    public String getReplyUrl() {
        return this.replyUrl;
    }

    public void setReplyUrl(String replyUrl) {
        this.replyUrl = replyUrl;
    }

    public String getAppIdUri() {
        return this.appIdUri;
    }

    public void setAppIdUri(String appIdUri) {
        this.appIdUri = appIdUri;
    }

    public Duration getJwtConnectTimeout() {
        return this.jwtConnectTimeout;
    }

    public void setJwtConnectTimeout(Duration jwtConnectTimeout) {
        this.jwtConnectTimeout = jwtConnectTimeout;
    }

    public Duration getJwtReadTimeout() {
        return this.jwtReadTimeout;
    }

    public void setJwtReadTimeout(Duration jwtReadTimeout) {
        this.jwtReadTimeout = jwtReadTimeout;
    }

    public int getJwtSizeLimit() {
        return this.jwtSizeLimit;
    }

    public void setJwtSizeLimit(int jwtSizeLimit) {
        this.jwtSizeLimit = jwtSizeLimit;
    }

    public AadB2cProfileProperties getProfile() {
        return this.profile;
    }

    public Map<String, AuthorizationClientProperties> getAuthorizationClients() {
        return this.authorizationClients;
    }
}

