/*
 * Decompiled with CFR 0.152.
 */
package com.biuqu.boot.aop;

import com.biuqu.boot.aop.BaseLogAop;
import com.biuqu.log.annotation.AuditLogAnn;
import com.biuqu.log.annotation.AuditLogModuleAnn;
import com.biuqu.log.model.BaseLog;
import com.biuqu.log.model.LogAopParam;
import java.lang.reflect.Method;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@Aspect
public class AuditLogAop
extends BaseLogAop {
    private static final Logger log = LoggerFactory.getLogger(AuditLogAop.class);

    @Around(value="@annotation(org.springframework.web.bind.annotation.PostMapping)&&@annotation(com.biuqu.log.annotation.AuditLogAnn)")
    public Object around(ProceedingJoinPoint joinPoint) {
        return super.around(joinPoint);
    }

    @Override
    protected BaseLog getLog(boolean isSdk, LogAopParam param, Method method) {
        if (!isSdk) {
            AuditLogAnn targetAnn = method.getAnnotation(AuditLogAnn.class);
            AuditLogModuleAnn moduleAnn = method.getDeclaringClass().getAnnotation(AuditLogModuleAnn.class);
            return targetAnn.mapper().getLog(targetAnn, moduleAnn, param);
        }
        return null;
    }
}

