/*
 * Decompiled with CFR 0.152.
 */
package com.biuqu.boot.aop;

import com.biuqu.aop.BaseAop;
import com.biuqu.errcode.ErrCodeEnum;
import com.biuqu.exception.CommonException;
import com.biuqu.log.model.BaseAuditLog;
import com.biuqu.log.model.BaseLog;
import com.biuqu.log.model.ClientLog;
import com.biuqu.log.model.LogAopParam;
import com.biuqu.log.service.LogFacade;
import com.biuqu.log.utils.IpUtil;
import com.biuqu.model.BaseSecurity;
import com.biuqu.model.GlobalDict;
import com.biuqu.model.JwtToken;
import com.biuqu.model.ResultCode;
import com.biuqu.service.BaseBizService;
import com.biuqu.utils.IdUtil;
import com.biuqu.utils.JwtUtil;
import com.biuqu.utils.UrlUtil;
import java.lang.reflect.Method;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public abstract class BaseLogAop
extends BaseAop {
    private static final Logger log = LoggerFactory.getLogger(BaseLogAop.class);
    @Autowired
    private BaseBizService<GlobalDict> dictService;
    @Autowired
    private LogFacade logFacade;

    protected Object doAround(ProceedingJoinPoint joinPoint) {
        try {
            return super.doAround(joinPoint);
        }
        catch (Exception e) {
            log.error("failed to add audit log.", (Throwable)e);
            ResultCode resultCode = e instanceof CommonException ? ResultCode.error((String)((CommonException)e).getErrCode().getCode()) : ResultCode.error((String)ErrCodeEnum.SERVER_ERROR.getCode());
            Object obj = this.doAroundBefore(this.getMethod((JoinPoint)joinPoint), joinPoint.getArgs());
            Object baseLog = obj instanceof BaseAuditLog ? (BaseAuditLog)obj : (ClientLog)obj;
            this.doAroundAfter(baseLog, null);
            return resultCode;
        }
    }

    protected Object doAroundBefore(Method method, Object[] args) {
        LogAopParam param = new LogAopParam();
        param.setCurTime(System.currentTimeMillis());
        HttpServletRequest req = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        param.setClientIp(IpUtil.getReqIp((HttpServletRequest)req));
        param.setUrl(UrlUtil.shortUrl((String)req.getRequestURI()));
        JwtToken jwtToken = JwtUtil.getJwtToken((String)req.getHeader("Authorization"));
        if (null != jwtToken && !StringUtils.isEmpty((CharSequence)jwtToken.toClientId())) {
            String userId = jwtToken.toClientId();
            if (StringUtils.isEmpty((CharSequence)userId)) {
                return null;
            }
            param.setUserId(userId);
            String reqId = req.getHeader("reqId");
            if (StringUtils.isEmpty((CharSequence)reqId)) {
                reqId = IdUtil.uuid();
            }
            param.setRepId(reqId);
            GlobalDict dict = new GlobalDict();
            dict.setValue(param.getUrl());
            GlobalDict urlDict = (GlobalDict)this.dictService.get((BaseSecurity)dict.toDict());
            String urlId = "";
            if (null != urlDict && !StringUtils.isEmpty((CharSequence)urlDict.getKey())) {
                urlId = urlDict.getKey();
            }
            param.setUrlId(urlId);
            return this.getLog(jwtToken.isSdk(), param, method);
        }
        return null;
    }

    protected void doAroundAfter(Object param, Object result) {
        if (!(param instanceof BaseLog)) {
            log.info("no need to save audit log.");
            return;
        }
        BaseLog baseLog = (BaseLog)param;
        this.logFacade.saveLog(baseLog);
    }

    protected abstract BaseLog getLog(boolean var1, LogAopParam var2, Method var3);
}

