/*
 * Decompiled with CFR 0.152.
 */
package com.biuqu.boot.aop;

import com.biuqu.aop.BaseAop;
import com.biuqu.boot.handler.ChannelLimitHandler;
import com.biuqu.errcode.ErrCodeEnum;
import com.biuqu.exception.CommonException;
import java.lang.reflect.Method;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Aspect
public class ChannelLimitAop
extends BaseAop {
    @Autowired
    private ChannelLimitHandler limitHandler;

    @Before(value="execution (* com.biuqu.boot.remote.RemoteService+.*invoke*(..))")
    public void before(JoinPoint joinPoint) {
        super.before(joinPoint);
    }

    protected void doBefore(Method method, Object[] args) {
        boolean isLimit = this.limitHandler.limit(method, args);
        if (isLimit) {
            throw new CommonException(ErrCodeEnum.LIMIT_ERROR.getCode());
        }
    }
}

