/*
 * Decompiled with CFR 0.152.
 */
package com.biuqu.boot.aop;

import com.biuqu.boot.aop.BaseLogAop;
import com.biuqu.log.model.BaseLog;
import com.biuqu.log.model.ClientLog;
import com.biuqu.log.model.LogAopParam;
import com.biuqu.model.ResultCode;
import java.lang.reflect.Method;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Component;

@Component
@Aspect
public class ClientLogAop
extends BaseLogAop {
    private static final Logger log = LoggerFactory.getLogger(ClientLogAop.class);

    @Around(value="@annotation(org.springframework.web.bind.annotation.PostMapping)&&@annotation(com.biuqu.log.annotation.ClientLogAnn)")
    public Object around(ProceedingJoinPoint joinPoint) {
        return super.around(joinPoint);
    }

    @Override
    protected BaseLog getLog(boolean isSdk, LogAopParam param, Method method) {
        if (!isSdk) {
            log.info("current audit request[{}/{}],no need to save client log.", (Object)param.getRepId(), (Object)param.getUrlId());
            return null;
        }
        ClientLog clientLog = new ClientLog();
        BeanUtils.copyProperties((Object)param, (Object)clientLog);
        return clientLog;
    }

    @Override
    protected void doAroundAfter(Object param, Object result) {
        if (!(param instanceof ClientLog)) {
            log.info("no need to save client log.");
            return;
        }
        ClientLog cLog = (ClientLog)param;
        if (result instanceof ResultCode) {
            ResultCode resultCode = (ResultCode)result;
            if (!StringUtils.isEmpty((CharSequence)resultCode.getReqId())) {
                cLog.setRepId(resultCode.getReqId());
            }
            cLog.setRespId(resultCode.getRespId());
            cLog.setCode(resultCode.getCode());
            cLog.setMsg(resultCode.getMsg());
            cLog.setChannelId(resultCode.getChannelId());
            cLog.setCost(System.currentTimeMillis() - cLog.getCurTime());
            log.info("[{}/{}]cost:{}/{}ms", new Object[]{cLog.getRepId(), cLog.getUrlId(), resultCode.getCost(), cLog.getCost()});
        }
        super.doAroundAfter(param, result);
    }
}

