/*
 * Decompiled with CFR 0.152.
 */
package com.biuqu.boot.aop;

import com.biuqu.annotation.DisableSecurityAnn;
import com.biuqu.aop.BaseAop;
import com.biuqu.hsm.BizHsmFacade;
import com.biuqu.model.BaseSecurity;
import com.google.common.collect.Lists;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Aspect
public class EncSecurityAop
extends BaseAop {
    private static final String ENABLE_SECURITY = "@annotation(com.biuqu.annotation.EnableSecurityAnn) && ";
    private static final String GET_DAO = "(execution (* com.biuqu.boot.dao.*.*SecDao.*get*(..)))";
    private static final String BATCH_GET_DAO = "(execution (* com.biuqu.boot.dao.*.*SecDao.*batch*(..)))";
    private static final String ADD_DAO = "(execution (* com.biuqu.boot.dao.*.*SecDao.*add*(..)))";
    private static final String UPDATE_DAO = "(execution (* com.biuqu.boot.dao.*.*SecDao.*update*(..)))";
    private static final String GET_SVC = "@annotation(com.biuqu.annotation.EnableSecurityAnn) && (execution (* com.biuqu.service.BaseBizService+.*get*(..)))";
    private static final String BATCH_GET_SVC = "@annotation(com.biuqu.annotation.EnableSecurityAnn) && (execution (* com.biuqu.service.BaseBizService+.*batch*(..)))";
    private static final String ADD_SVC = "@annotation(com.biuqu.annotation.EnableSecurityAnn) && (execution (* com.biuqu.service.BaseBizService+.*add*(..)))";
    private static final String UPDATE_SVC = "@annotation(com.biuqu.annotation.EnableSecurityAnn) && (execution (* com.biuqu.service.BaseBizService+.*update*(..)))";
    private static final String BEFORE_PATTERN = "(execution (* com.biuqu.boot.dao.*.*SecDao.*add*(..)))||(execution (* com.biuqu.boot.dao.*.*SecDao.*update*(..)))||@annotation(com.biuqu.annotation.EnableSecurityAnn) && (execution (* com.biuqu.service.BaseBizService+.*add*(..)))||@annotation(com.biuqu.annotation.EnableSecurityAnn) && (execution (* com.biuqu.service.BaseBizService+.*update*(..)))";
    private static final String AFTER_PATTERN = "(execution (* com.biuqu.boot.dao.*.*SecDao.*get*(..)))||(execution (* com.biuqu.boot.dao.*.*SecDao.*batch*(..)))||@annotation(com.biuqu.annotation.EnableSecurityAnn) && (execution (* com.biuqu.service.BaseBizService+.*get*(..)))||@annotation(com.biuqu.annotation.EnableSecurityAnn) && (execution (* com.biuqu.service.BaseBizService+.*batch*(..)))";
    @Autowired
    private BizHsmFacade bizHsm;

    @Before(value="(execution (* com.biuqu.boot.dao.*.*SecDao.*add*(..)))||(execution (* com.biuqu.boot.dao.*.*SecDao.*update*(..)))||@annotation(com.biuqu.annotation.EnableSecurityAnn) && (execution (* com.biuqu.service.BaseBizService+.*add*(..)))||@annotation(com.biuqu.annotation.EnableSecurityAnn) && (execution (* com.biuqu.service.BaseBizService+.*update*(..)))")
    public void before(JoinPoint joinPoint) {
        super.before(joinPoint);
    }

    @AfterReturning(value="(execution (* com.biuqu.boot.dao.*.*SecDao.*get*(..)))||(execution (* com.biuqu.boot.dao.*.*SecDao.*batch*(..)))||@annotation(com.biuqu.annotation.EnableSecurityAnn) && (execution (* com.biuqu.service.BaseBizService+.*get*(..)))||@annotation(com.biuqu.annotation.EnableSecurityAnn) && (execution (* com.biuqu.service.BaseBizService+.*batch*(..)))", returning="result")
    public void after(JoinPoint joinPoint, Object result) {
        super.after(joinPoint, result);
    }

    protected void doBefore(Method method, Object[] args) {
        List<BaseSecurity> models = this.getModels(method, args, DisableSecurityAnn.class);
        this.bizHsm.before(models);
    }

    protected void doAfter(Method method, Object[] args, Object result) {
        List<BaseSecurity> models = this.getModels(method, result, DisableSecurityAnn.class);
        this.bizHsm.after(models);
    }

    private List<BaseSecurity> getModels(Method method, Object result, Class<? extends Annotation> ignoreClazz) {
        ArrayList models = Lists.newArrayList();
        Annotation ignoreAnn = method.getAnnotation(ignoreClazz);
        if (null != ignoreAnn) {
            return models;
        }
        if (result instanceof List) {
            List list = (List)result;
            for (Object model : list) {
                if (!(model instanceof BaseSecurity)) continue;
                models.add((BaseSecurity)model);
            }
        } else if (result instanceof BaseSecurity) {
            models.add((BaseSecurity)result);
        }
        return models;
    }

    private List<BaseSecurity> getModels(Method method, Object[] args, Class<? extends Annotation> ignoreClazz) {
        ArrayList models = Lists.newArrayList();
        if (ArrayUtils.isEmpty((Object[])args)) {
            return models;
        }
        models.addAll(this.getModels(method, args[0], ignoreClazz));
        return models;
    }
}

