/*
 * Decompiled with CFR 0.152.
 */
package com.biuqu.boot.configure;

import com.biuqu.boot.model.MdcAccessLogValve;
import com.biuqu.log.dao.LogDao;
import com.biuqu.log.dao.impl.OpLogDaoImpl;
import com.biuqu.log.dao.impl.SecLogDaoImpl;
import com.biuqu.log.dao.impl.SysLogDaoImpl;
import com.biuqu.log.model.OperationLog;
import com.biuqu.log.model.SecurityLog;
import com.biuqu.log.model.SystemLog;
import com.biuqu.log.service.LogFacade;
import com.google.common.collect.Lists;
import java.util.Collection;
import org.apache.catalina.valves.AccessLogValve;
import org.springframework.boot.web.embedded.tomcat.ConfigurableTomcatWebServerFactory;
import org.springframework.boot.web.embedded.tomcat.TomcatServletWebServerFactory;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
public class LogConfigurer {
    @Bean
    public WebServerFactoryCustomizer<ConfigurableTomcatWebServerFactory> accessLog(Environment env) {
        return factory -> {
            MdcAccessLogValve valve = new MdcAccessLogValve();
            valve.setPattern(env.getProperty("server.tomcat.accesslog.pattern"));
            if (factory instanceof TomcatServletWebServerFactory) {
                TomcatServletWebServerFactory tsFactory = (TomcatServletWebServerFactory)factory;
                tsFactory.setEngineValves((Collection)Lists.newArrayList((Object[])new AccessLogValve[]{valve}));
            }
        };
    }

    @Bean
    public LogDao<SystemLog> sysLog() {
        return new SysLogDaoImpl();
    }

    @Bean
    public LogDao<OperationLog> opLog() {
        return new OpLogDaoImpl();
    }

    @Bean
    public LogDao<SecurityLog> secLog() {
        return new SecLogDaoImpl();
    }

    @Bean
    public LogFacade facade(LogDao<OperationLog> opDao, LogDao<SecurityLog> secDao, LogDao<SystemLog> sysDao) {
        return new LogFacade(opDao, secDao, sysDao);
    }
}

