/*
 * Decompiled with CFR 0.152.
 */
package com.biuqu.boot.configure;

import com.biuqu.boot.configure.BaseWebConfigurer;
import com.biuqu.json.JsonMappers;
import com.biuqu.model.BaseSecurity;
import com.biuqu.model.GlobalDict;
import com.biuqu.service.BaseBizService;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.util.CollectionUtils;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;

@Configuration
public class WebMvcConfigurer
extends BaseWebConfigurer {
    private static final Logger log = LoggerFactory.getLogger(WebMvcConfigurer.class);
    private static final String ACTUATOR_TYPE = "vnd.spring-boot.actuator.v3+json";
    @Resource(name="globalDictSvc")
    private BaseBizService<GlobalDict> dictService;
    @Resource(name="clientLimitSvc")
    private HandlerInterceptor limitHandler;
    @Value(value="${bq.json.snake-case:true}")
    private boolean snakeCase;
    @Value(value="${bq.web.invalid-urls:''}")
    private String invalidUrls;
    @Value(value="${bq.limit.enabled:false}")
    private boolean limitEnabled;

    @Override
    protected void addInterceptors(InterceptorRegistry registry) {
        super.addInterceptors(registry);
        if (!this.limitEnabled) {
            log.info("disabled limit access.");
            return;
        }
        InterceptorRegistration registration = registry.addInterceptor(this.limitHandler);
        GlobalDict param = new GlobalDict().toDict();
        List batchDict = this.dictService.getBatch((BaseSecurity)param);
        HashSet urls = Sets.newHashSet();
        if (!CollectionUtils.isEmpty((Collection)batchDict)) {
            for (GlobalDict dict : batchDict) {
                urls.add(dict.getValue());
            }
        }
        registration.addPathPatterns((List)Lists.newArrayList((Iterable)urls));
    }

    protected void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler(new String[]{"/assets/**"}).addResourceLocations(new String[]{"classpath:/static/assets"});
        super.addResourceHandlers(registry);
    }

    protected void extendMessageConverters(List<HttpMessageConverter<?>> converters) {
        for (int i = 0; i < converters.size(); ++i) {
            HttpMessageConverter<?> converter = converters.get(i);
            if (!(converter instanceof MappingJackson2HttpMessageConverter)) continue;
            ObjectMapper mapper = JsonMappers.getMapper((boolean)this.snakeCase);
            MappingJackson2HttpMessageConverter conv = new MappingJackson2HttpMessageConverter();
            conv.setObjectMapper(mapper);
            ArrayList types = Lists.newArrayList();
            MediaType utf8Type = new MediaType(MediaType.APPLICATION_JSON, StandardCharsets.UTF_8);
            types.add(utf8Type);
            MediaType actuatorType = new MediaType(MediaType.APPLICATION_JSON.getType(), ACTUATOR_TYPE);
            types.add(actuatorType);
            conv.setSupportedMediaTypes((List)types);
            converters.set(i, (HttpMessageConverter<?>)conv);
            break;
        }
    }

    @Override
    protected Set<String> getInvalidPatterns() {
        HashSet urls = null;
        if (!StringUtils.isEmpty((CharSequence)this.invalidUrls)) {
            urls = Sets.newHashSet((Object[])StringUtils.split((String)this.invalidUrls, (String)","));
        }
        return urls;
    }
}

