/*
 * Decompiled with CFR 0.152.
 */
package com.biuqu.boot.filter;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.springframework.web.util.ContentCachingRequestWrapper;

public class CachingRequestWrapper
extends ContentCachingRequestWrapper {
    private byte[] body;

    public CachingRequestWrapper(HttpServletRequest request) {
        super(request);
        super.getParameterMap();
        this.body = super.getContentAsByteArray();
        if (this.body.length == 0) {
            try {
                this.body = IOUtils.toByteArray((InputStream)super.getInputStream());
            }
            catch (IOException ex) {
                this.body = new byte[0];
            }
        }
    }

    public ServletInputStream getInputStream() {
        return new CachingRequestInputStream(this.body);
    }

    private static class CachingRequestInputStream
    extends ServletInputStream {
        private final ByteArrayInputStream inputStream;

        public CachingRequestInputStream(byte[] bytes) {
            this.inputStream = new ByteArrayInputStream(bytes);
        }

        public int read() {
            return this.inputStream.read();
        }

        public boolean isFinished() {
            return this.inputStream.available() == 0;
        }

        public boolean isReady() {
            return true;
        }

        public void setReadListener(ReadListener readlistener) {
        }
    }
}

