/*
 * Decompiled with CFR 0.152.
 */
package com.biuqu.boot.filter;

import com.biuqu.boot.filter.CachingRequestWrapper;
import com.biuqu.boot.utils.ResponseUtil;
import com.biuqu.encryption.Hash;
import com.biuqu.encryption.factory.EncryptionFactory;
import com.biuqu.errcode.ErrCodeEnum;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.entity.ContentType;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

public class SecurityValidFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(SecurityValidFilter.class);
    private static final String SIGN_KEY = "sign";
    private static final Hash HASH = (Hash)EncryptionFactory.SHAHash.createAlgorithm();
    @Value(value="${bq.json.snake-case:true}")
    private boolean snakeCase;

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        long start = System.currentTimeMillis();
        if (request instanceof HttpServletRequest) {
            HttpServletRequest req = (HttpServletRequest)request;
            String type = req.getContentType();
            String sign = req.getHeader(SIGN_KEY);
            if (!StringUtils.isEmpty((CharSequence)sign) && ContentType.APPLICATION_JSON.toString().contains(type)) {
                CachingRequestWrapper requestWrapper = new CachingRequestWrapper(req);
                String authorization = req.getHeader("Authorization");
                if (StringUtils.isEmpty((CharSequence)authorization)) {
                    authorization = "";
                }
                String body = IOUtils.toString((byte[])requestWrapper.getContentAsByteArray(), (String)StandardCharsets.UTF_8.name());
                String data = authorization + "_" + body;
                byte[] hashBytes = HASH.digest(data.getBytes(StandardCharsets.UTF_8));
                String calcSign = Hex.toHexString((byte[])hashBytes);
                log.info("***json:{},sign:{},cost:{}ms", new Object[]{data, calcSign, System.currentTimeMillis() - start});
                if (!sign.equals(calcSign)) {
                    String code = ErrCodeEnum.SIGNATURE_ERROR.getCode();
                    ResponseUtil.writeErrorBody((HttpServletResponse)((HttpServletResponse)response), (String)code, (boolean)this.snakeCase);
                    return;
                }
                log.info("cache and valid sign[{}] cost {}ms", (Object)req.getRequestURI(), (Object)(System.currentTimeMillis() - start));
                filterChain.doFilter((ServletRequest)requestWrapper, response);
                return;
            }
        }
        filterChain.doFilter(request, response);
    }
}

