/*
 * Decompiled with CFR 0.152.
 */
package com.biuqu.boot.handler;

import com.biuqu.boot.handler.LimitHandler;
import com.biuqu.boot.model.AccessLimit;
import com.biuqu.boot.service.AssemblyConfService;
import com.biuqu.boot.utils.ResponseUtil;
import com.biuqu.errcode.ErrCodeEnum;
import com.biuqu.model.JwtToken;
import com.biuqu.model.LimitConfig;
import com.biuqu.model.ResultCode;
import com.biuqu.utils.JsonUtil;
import com.biuqu.utils.JwtUtil;
import com.biuqu.utils.UrlUtil;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;

@Component(value="clientLimitSvc")
public class ClientLimitHandler
implements HandlerInterceptor {
    @Value(value="${bq.json.snake-case:true}")
    private boolean snakeCase;
    @Autowired
    private LimitHandler limitHandler;
    @Autowired
    private AssemblyConfService assemblyConfService;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        JwtToken token = JwtUtil.getJwtToken((String)request.getHeader("Authorization"));
        if (null == token || StringUtils.isEmpty((CharSequence)token.toClientId())) {
            return true;
        }
        Map urls = MapUtils.invertMap(this.assemblyConfService.getClientUrl());
        String urlId = (String)urls.get(UrlUtil.shortUrl((String)request.getRequestURI()));
        if (StringUtils.isEmpty((CharSequence)urlId)) {
            return true;
        }
        AccessLimit model = new AccessLimit();
        model.setUrlId(urlId);
        model.setAccessId(token.toClientId());
        model.setConfig(LimitConfig.clientConf());
        boolean needLimit = this.limitHandler.limit(model);
        if (needLimit) {
            ResultCode resultCode = ResultCode.error((String)ErrCodeEnum.LIMIT_ERROR.getCode());
            ResponseUtil.writeErrorBody((HttpServletResponse)response, (String)JsonUtil.toJson((Object)resultCode, (boolean)this.snakeCase));
            return false;
        }
        return true;
    }
}

