/*
 * Decompiled with CFR 0.152.
 */
package com.biuqu.boot.handler;

import com.biuqu.errcode.ErrCodeMgr;
import com.biuqu.exception.CommonException;
import com.biuqu.handler.BaseExceptionHandler;
import com.biuqu.model.ErrCode;
import com.biuqu.model.ResultCode;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.util.CollectionUtils;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.servlet.NoHandlerFoundException;

@ControllerAdvice
public class GlobalExceptionHandler
extends BaseExceptionHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(GlobalExceptionHandler.class);

    @ExceptionHandler(value={CommonException.class, NoHandlerFoundException.class, Exception.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ResponseBody
    public ResultCode<?> handleErr(HttpServletRequest req, Exception e) {
        return this.handle(req.getRequestURI(), e);
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ResponseBody
    public ResultCode<?> handleValidErr(HttpServletRequest req, MethodArgumentNotValidException e) {
        List errors = e.getBindingResult().getAllErrors();
        if (CollectionUtils.isEmpty((Collection)errors)) {
            ErrCode errCode = this.getByUrl(req.getRequestURI(), ErrCodeMgr.getServerErr().getCode());
            return ResultCode.error((String)errCode.getCode());
        }
        for (ObjectError error : errors) {
            String code = error.getDefaultMessage();
            if (StringUtils.isEmpty((CharSequence)code) || !code.contains("_")) continue;
            return ResultCode.build((ErrCode)ErrCodeMgr.getValid((String)code));
        }
        return ResultCode.build((ErrCode)ErrCodeMgr.getServerErr());
    }

    protected ErrCode getByUrl(String url, String code) {
        LOGGER.error("current[{}] request happened err:{}", (Object)url, (Object)code);
        return ErrCodeMgr.get((String)code);
    }
}

