/*
 * Decompiled with CFR 0.152.
 */
package com.biuqu.boot.handler.impl;

import com.biuqu.boot.handler.LimitHandler;
import com.biuqu.boot.model.AccessLimit;
import com.biuqu.boot.service.LimitService;
import com.biuqu.model.BaseSecurity;
import com.biuqu.model.GlobalConfig;
import com.biuqu.model.LimitConfig;
import com.biuqu.service.BaseBizService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LimitHandlerImpl
implements LimitHandler {
    @Autowired
    private BaseBizService<GlobalConfig> confService;
    @Autowired
    private LimitService limitService;

    @Override
    public boolean limit(AccessLimit model) {
        boolean qpsResult;
        boolean maxResult;
        LimitConfig limitConf = model.getConfig();
        LimitConfig maxConfig = this.getLimit(limitConf, limitConf.toMaxDbKey(), limitConf.toMaxDbUnitKey());
        if (!maxConfig.isEmpty() && (maxResult = this.limitService.maxLimit(maxConfig))) {
            return true;
        }
        LimitConfig qpsConfig = this.getLimit(limitConf, limitConf.toQpsDbKey(), limitConf.toQpsDbUnitKey());
        return !qpsConfig.isEmpty() && (qpsResult = this.limitService.qpsLimit(qpsConfig));
    }

    private LimitConfig getLimit(LimitConfig param, String limitKey, String limitUnitKey) {
        param.setSvcId(limitKey);
        LimitConfig resultConf = param.rebuild();
        GlobalConfig config = (GlobalConfig)this.confService.get((BaseSecurity)param);
        if (!config.isEmpty()) {
            resultConf.setSvcValue(config.getSvcValue());
            param.setSvcId(limitUnitKey);
            GlobalConfig unitConf = (GlobalConfig)this.confService.get((BaseSecurity)param);
            String unit = null;
            if (!unitConf.isEmpty()) {
                unit = unitConf.getSvcValue();
            }
            resultConf.setUnit(unit);
            return resultConf;
        }
        return resultConf;
    }
}

