/*
 * Decompiled with CFR 0.152.
 */
package com.biuqu.boot.model;

import java.io.CharArrayWriter;
import org.apache.catalina.valves.AbstractAccessLogValve;
import org.apache.catalina.valves.AccessLogValve;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.sleuth.TraceContext;
import org.springframework.util.ClassUtils;

public class MdcAccessLogValve
extends AccessLogValve {
    private static final Logger log = LoggerFactory.getLogger(MdcAccessLogValve.class);
    private static final String SLEUTH_TYPE = "org.springframework.cloud.sleuth.TraceContext";

    public void log(CharArrayWriter message) {
        log.info(message.toString());
    }

    protected AbstractAccessLogValve.AccessLogElement createAccessLogElement(String name, char pattern) {
        if (pattern == 'M') {
            return (buf, date, request, response, time) -> {
                boolean existTrace = ClassUtils.isPresent((String)SLEUTH_TYPE, (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
                if (!existTrace) {
                    buf.append("-");
                    return;
                }
                Object context = request.getRequest().getAttribute(TraceContext.class.getName());
                if (!(context instanceof TraceContext)) {
                    return;
                }
                TraceContext traceContext = (TraceContext)context;
                if ("traceId".equalsIgnoreCase(name)) {
                    buf.append(traceContext.traceId());
                } else if ("spanId".equalsIgnoreCase(name)) {
                    buf.append(traceContext.spanId());
                }
            };
        }
        return super.createAccessLogElement(name, pattern);
    }
}

