/*
 * Decompiled with CFR 0.152.
 */
package com.biuqu.boot.remote;

import com.biuqu.boot.remote.RemoteService;
import com.biuqu.boot.service.AssemblyConfService;
import com.biuqu.errcode.ErrCodeEnum;
import com.biuqu.http.CommonRestTemplate;
import com.biuqu.model.BaseBiz;
import com.biuqu.model.GlobalConfig;
import com.biuqu.model.GlobalDict;
import com.biuqu.model.ResultCode;
import com.biuqu.utils.JsonUtil;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class BaseRemoteService<O, T extends BaseBiz<O>>
implements RemoteService<O, T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseRemoteService.class);
    @Autowired(required=false)
    private AssemblyConfService assemblyConfService;
    @Autowired(required=false)
    private CommonRestTemplate restTemplate;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultCode<O> invoke(T model) {
        ResultCode resultCode = null;
        try {
            boolean channelStatus = this.queryChannelStatus(model, GlobalDict.toChannelStatus().getKey());
            if (!channelStatus) {
                LOGGER.error("[{}]channel[{}] is not active.", (Object)model.getUrlId(), (Object)model.getChannelId());
                ResultCode resultCode2 = resultCode = ResultCode.error((String)ErrCodeEnum.CHANNEL_ERROR.getCode());
                return resultCode2;
            }
            boolean snake = this.queryChannelStatus(model, GlobalDict.toChannelSnake().getKey());
            String resultJson = this.call(model, snake);
            if (StringUtils.isEmpty((CharSequence)resultJson)) {
                LOGGER.error("no channel[{}] result found.", (Object)model.getUrlId());
                ResultCode resultCode3 = resultCode = ResultCode.error((String)ErrCodeEnum.SERVER_ERROR.getCode());
                return resultCode3;
            }
            resultCode = this.toModel(resultJson, model.toTypeRef(), snake);
            if (null == resultCode) {
                LOGGER.error("channel[{},{}]'s result has happened error.", (Object)model.getUrlId(), (Object)model.getUrlId());
                ResultCode resultCode4 = resultCode = ResultCode.error((String)ErrCodeEnum.CHANNEL_ERROR.getCode());
                return resultCode4;
            }
        }
        finally {
            if (null != resultCode) {
                resultCode.setReqId(model.getReqId());
                resultCode.setRespId(model.getRespId());
                resultCode.setChannelId(model.getChannelId());
            }
        }
        return resultCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultCode<List<O>> invokeBatch(T model) {
        ResultCode resultCode = null;
        try {
            boolean channelStatus = this.queryChannelStatus(model, GlobalDict.toChannelStatus().getKey());
            if (!channelStatus) {
                LOGGER.error("[{}]channels[{}] is not active.", (Object)model.getUrlId(), (Object)model.getChannelId());
                ResultCode resultCode2 = resultCode = ResultCode.error((String)ErrCodeEnum.CHANNEL_ERROR.getCode());
                return resultCode2;
            }
            boolean snake = this.queryChannelStatus(model, GlobalDict.toChannelSnake().getKey());
            String resultJson = this.call(model, snake);
            if (StringUtils.isEmpty((CharSequence)resultJson)) {
                LOGGER.error("no channel[{}] results found.", (Object)model.getUrlId());
                ResultCode resultCode3 = resultCode = ResultCode.error((String)ErrCodeEnum.SERVER_ERROR.getCode());
                return resultCode3;
            }
            resultCode = this.toModels(resultJson, model.toTypeRefs(), snake);
            if (null == resultCode) {
                LOGGER.error("channel[{},{}]'s results have happened error.", (Object)model.getUrlId(), (Object)model.getUrlId());
                ResultCode resultCode4 = resultCode = ResultCode.error((String)ErrCodeEnum.CHANNEL_ERROR.getCode());
                return resultCode4;
            }
        }
        finally {
            if (null != resultCode) {
                resultCode.setRespId(model.getRespId());
                resultCode.setChannelId(model.getChannelId());
            }
        }
        return resultCode;
    }

    protected String call(T model, boolean snake) {
        String channelUrl = this.getChannelUrl(model);
        if (StringUtils.isEmpty((CharSequence)channelUrl)) {
            LOGGER.error("[{}]no channel[{}] url found.", (Object)model.getUrlId(), (Object)model.getChannelId());
            return null;
        }
        String paramJson = JsonUtil.toJson((Object)model.toRemote(), (boolean)snake);
        return this.restTemplate.invoke(channelUrl, null, paramJson);
    }

    protected String getChannelUrl(T model) {
        Map<String, String> channelUrls = this.assemblyConfService.getChannelUrl();
        return channelUrls.get(model.getChannelId());
    }

    protected ResultCode<O> toModel(String json, TypeReference<ResultCode<O>> typeRef, boolean snake) {
        if (StringUtils.isEmpty((CharSequence)json)) {
            return null;
        }
        return (ResultCode)JsonUtil.toComplex((String)json, typeRef, (boolean)snake);
    }

    protected ResultCode<List<O>> toModels(String json, TypeReference<ResultCode<List<O>>> typeRefs, boolean snake) {
        if (StringUtils.isEmpty((CharSequence)json)) {
            return null;
        }
        return (ResultCode)JsonUtil.toComplex((String)json, typeRefs, (boolean)snake);
    }

    private boolean queryChannelStatus(T model, String key) {
        GlobalConfig config = new GlobalConfig();
        config.setUrlId(model.getChannelId());
        Map<String, String> dictMap = this.assemblyConfService.getChannelDict(config);
        String result = Boolean.FALSE.toString();
        if (dictMap.containsKey(key)) {
            result = dictMap.get(key);
        }
        return Boolean.TRUE.toString().equalsIgnoreCase(result);
    }
}

