/*
 * Decompiled with CFR 0.152.
 */
package com.biuqu.boot.service;

import com.biuqu.boot.remote.RemoteService;
import com.biuqu.boot.service.AssemblyConfService;
import com.biuqu.boot.service.RestService;
import com.biuqu.errcode.ErrCodeEnum;
import com.biuqu.exception.CommonException;
import com.biuqu.model.BaseBiz;
import com.biuqu.model.GlobalConfig;
import com.biuqu.model.ResultCode;
import com.biuqu.service.BaseBizService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class BaseRestService<O, T extends BaseBiz<O>>
implements RestService<O, T> {
    private static final Logger log = LoggerFactory.getLogger(BaseRestService.class);
    @Autowired(required=false)
    private BaseBizService<T> service;
    @Resource(name="defaultRemoteSvc")
    private RemoteService<O, T> remoteService;
    @Autowired
    private AssemblyConfService assemblyConfService;

    @Override
    public ResultCode<List<O>> batchExecute(T model) {
        if (null == model) {
            log.error("failed to get valid parameter.");
            return ResultCode.error((String)ErrCodeEnum.VALID_ERROR.getCode());
        }
        this.appendConfig(model);
        return this.invokeBatchResult(model);
    }

    @Override
    public ResultCode<O> execute(T model) {
        if (null == model) {
            log.error("failed to get valid parameter.");
            return ResultCode.error((String)ErrCodeEnum.VALID_ERROR.getCode());
        }
        this.appendConfig(model);
        return this.invokeResult(model);
    }

    @Override
    public ResultCode<O> add(T model) {
        int result = this.service.add(model);
        if (result > 0) {
            ResultCode.ok(null);
        }
        return ResultCode.error((String)ErrCodeEnum.ADD_ERROR.getCode());
    }

    @Override
    public ResultCode<O> get(T model) {
        BaseBiz result = (BaseBiz)this.service.get(model);
        return ResultCode.ok((Object)result.toModel());
    }

    @Override
    public ResultCode<List<O>> getBatch(T model) {
        List batch = this.service.getBatch(model);
        ArrayList results = Lists.newArrayList();
        for (BaseBiz t : batch) {
            Object result = t.toModel();
            if (null == result) continue;
            results.add(result);
        }
        return ResultCode.ok((Object)results);
    }

    @Override
    public ResultCode<O> update(T model) {
        int result = this.service.update(model);
        if (result > 0) {
            ResultCode.ok(null);
        }
        return ResultCode.error((String)ErrCodeEnum.UPDATE_ERROR.getCode());
    }

    @Override
    public ResultCode<O> delete(T model) {
        int result = this.service.delete(model);
        if (result > 0) {
            ResultCode.ok(null);
        }
        return ResultCode.error((String)ErrCodeEnum.DELETE_ERROR.getCode());
    }

    protected void appendConfig(T model) {
        Map urls = MapUtils.invertMap(this.assemblyConfService.getClientUrl());
        String urlId = (String)urls.get(model.getUrl());
        if (!StringUtils.isEmpty((CharSequence)urlId)) {
            model.setUrlId(urlId);
        }
        GlobalConfig config = new GlobalConfig();
        config.setClientId(model.getUserId());
        config.setUrlId(model.getUrlId());
        List<GlobalConfig> configResults = this.assemblyConfService.getChannelConf(config);
        model.appendConf(configResults);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ResultCode<O> invokeResult(T model) {
        ResultCode resultCode = ResultCode.error((String)ErrCodeEnum.SERVER_ERROR.getCode());
        try {
            resultCode = this.getRemoteService().invoke(model);
        }
        catch (CommonException e) {
            resultCode = ResultCode.error((String)e.getErrCode().getCode());
        }
        catch (Exception e) {
            log.error("unknown error in channel.", (Throwable)e);
        }
        finally {
            resultCode.setReqId(model.getReqId());
            resultCode.setCost(System.currentTimeMillis() - model.getStart());
        }
        return resultCode;
    }

    protected ResultCode<List<O>> invokeBatchResult(T model) {
        return this.getRemoteService().invokeBatch(model);
    }

    protected RemoteService<O, T> getRemoteService() {
        return this.remoteService;
    }
}

