/*
 * Decompiled with CFR 0.152.
 */
package com.biuqu.boot.service.impl;

import com.biuqu.boot.service.AssemblyConfService;
import com.biuqu.model.BaseSecurity;
import com.biuqu.model.GlobalConfig;
import com.biuqu.model.GlobalDict;
import com.biuqu.service.BaseBizService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AssemblyConfServiceImpl
implements AssemblyConfService {
    @Autowired
    private BaseBizService<GlobalDict> dictService;
    @Autowired
    private BaseBizService<GlobalConfig> confService;

    @Override
    public Map<String, String> getClientUrl() {
        GlobalDict dictParam = new GlobalDict().toDict();
        List batchDict = this.dictService.getBatch((BaseSecurity)dictParam);
        return this.getUrlMap(batchDict);
    }

    @Override
    public Map<String, String> getChannelUrl() {
        GlobalDict dictParam = GlobalDict.toChannelUrl();
        List batchDict = this.dictService.getBatch((BaseSecurity)dictParam);
        return this.getUrlMap(batchDict);
    }

    @Override
    public Map<String, String> getChannelDict(GlobalConfig confParam) {
        GlobalDict dictParam = new GlobalDict();
        dictParam.setType(confParam.getUrlId());
        HashMap dictMap = Maps.newHashMap();
        List batchDict = this.dictService.getBatch((BaseSecurity)dictParam);
        for (GlobalDict dict : batchDict) {
            dictMap.put(dict.getKey(), dict.getValue());
        }
        return dictMap;
    }

    @Override
    public List<GlobalConfig> getClientConf(GlobalConfig confParam) {
        GlobalDict dictParam = GlobalDict.toClientDict();
        dictParam.setKey(confParam.getUrlId());
        return this.getConf(confParam, dictParam);
    }

    @Override
    public List<GlobalConfig> getChannelConf(GlobalConfig confParam) {
        GlobalDict dictParam = GlobalDict.toChannelDict();
        dictParam.setKey(confParam.getUrlId());
        return this.getConf(confParam, dictParam);
    }

    private List<GlobalConfig> getConf(GlobalConfig confParam, GlobalDict dictParam) {
        List batchDict = this.dictService.getBatch((BaseSecurity)dictParam);
        ArrayList confParams = Lists.newArrayList();
        for (GlobalDict dict : batchDict) {
            GlobalConfig param = new GlobalConfig();
            param.setClientId(confParam.getClientId());
            param.setUrlId(confParam.getUrlId());
            param.setSvcId(dict.getValue());
            confParams.add(param);
        }
        return this.confService.batchGet((List)confParams);
    }

    private Map<String, String> getUrlMap(List<GlobalDict> batchDict) {
        HashMap urlMap = Maps.newHashMap();
        for (GlobalDict dict : batchDict) {
            urlMap.put(dict.getKey(), dict.getValue());
        }
        return urlMap;
    }
}

