/*
 * Decompiled with CFR 0.152.
 */
package com.biuqu.boot.service.impl;

import com.biuqu.boot.dao.BizDao;
import com.biuqu.model.BaseSecurity;
import com.biuqu.model.GlobalConfig;
import com.biuqu.service.BaseBizService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="globalConfigSvc")
public class ConfigBizServiceImpl
extends BaseBizService<GlobalConfig> {
    @Autowired
    private BizDao<GlobalConfig> dao;

    public GlobalConfig get(GlobalConfig model) {
        List batch = this.getBatch((BaseSecurity)model);
        return this.getBest(batch);
    }

    protected List<GlobalConfig> queryBatchByKey(String key) {
        return this.dao.getBatch(GlobalConfig.toBean((String)key));
    }

    protected List<GlobalConfig> queryBatchByKeys(Iterable<? extends String> keys) {
        ArrayList configs = Lists.newArrayList();
        for (String string : keys) {
            configs.add(GlobalConfig.toBean((String)string));
        }
        return this.dao.batchGet(configs);
    }

    protected List<GlobalConfig> bestChoose(List<GlobalConfig> batch) {
        ArrayList bestResults = Lists.newArrayList();
        GlobalConfig best = this.getBest(batch);
        if (!best.isEmpty()) {
            bestResults.add(best);
        }
        return super.bestChoose(batch);
    }

    private GlobalConfig getBest(List<GlobalConfig> batch) {
        if (CollectionUtils.isEmpty(batch)) {
            return new GlobalConfig();
        }
        for (GlobalConfig config : batch) {
            if (StringUtils.isEmpty((CharSequence)config.getClientId()) || StringUtils.isEmpty((CharSequence)config.getUrlId())) continue;
            return config;
        }
        for (GlobalConfig config : batch) {
            if (StringUtils.isEmpty((CharSequence)config.getClientId()) || !StringUtils.isEmpty((CharSequence)config.getUrlId())) continue;
            return config;
        }
        for (GlobalConfig config : batch) {
            if (!StringUtils.isEmpty((CharSequence)config.getClientId()) || StringUtils.isEmpty((CharSequence)config.getUrlId())) continue;
            return config;
        }
        return batch.get(0);
    }
}

