/*
 * Decompiled with CFR 0.152.
 */
package com.biuqu.boot.service.impl;

import com.biuqu.boot.service.LimitService;
import com.biuqu.boot.service.RedisService;
import com.biuqu.model.LimitConfig;
import com.biuqu.utils.MathUtil;
import com.biuqu.utils.TimeUtil;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class LimitServiceImpl
implements LimitService {
    @Autowired
    private RedisService redis;
    @Value(value="${bq.limit.qps:100}")
    private long qps;
    @Value(value="${bq.limit.max:10000}")
    private long max;
    @Value(value="${bq.limit.qpsUnit:1000}")
    private long qpsUnit;
    @Value(value="${bq.limit.maxUnit:86400000}")
    private long maxUnit;

    @Override
    public boolean qpsLimit(LimitConfig config) {
        ArrayList keys = Lists.newArrayList((Object[])new String[]{config.toKey()});
        Object[] params = new Object[3];
        int i = 0;
        params[i++] = MathUtil.getLong((String)config.getSvcValue(), (long)this.qps);
        params[i++] = MathUtil.getLong((String)config.getUnit(), (long)this.qpsUnit);
        params[i] = System.currentTimeMillis();
        Boolean result = (Boolean)this.redis.execute("qpsRestScriptSvc", Boolean.class, (List)keys, params);
        return Boolean.TRUE.equals(result);
    }

    @Override
    public boolean maxLimit(LimitConfig config) {
        ArrayList keys = Lists.newArrayList((Object[])new String[]{config.toKey()});
        Object[] params = new Object[2];
        int i = 0;
        params[i++] = MathUtil.getLong((String)config.getSvcValue(), (long)this.max);
        params[i] = TimeUtil.getTodayUtcMills() + MathUtil.getLong((String)config.getUnit(), (long)this.maxUnit);
        Boolean result = (Boolean)this.redis.execute("maxRestScriptSvc", Boolean.class, (List)keys, params);
        return Boolean.TRUE.equals(result);
    }
}

