/*
 * Decompiled with CFR 0.152.
 */
package com.biuqu.boot.web;

import com.biuqu.errcode.ErrCodeEnum;
import com.biuqu.exception.CommonException;
import com.biuqu.model.ResultCode;
import com.biuqu.utils.JsonUtil;
import io.github.resilience4j.circuitbreaker.CallNotPermittedException;
import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.circuitbreaker.CircuitBreakerRegistry;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public abstract class BaseServletFallbackController<T, O> {
    private static final Logger log = LoggerFactory.getLogger(BaseServletFallbackController.class);
    @Autowired
    private CircuitBreakerRegistry circuitRegistry;

    protected ResultCode<O> circuitFallback(T model, Throwable e) {
        if (e instanceof CallNotPermittedException) {
            String name = ((CallNotPermittedException)e).getCausingCircuitBreakerName();
            CircuitBreaker circuitBreaker = this.circuitRegistry.circuitBreaker(name);
            CircuitBreaker.Metrics metrics = circuitBreaker.getMetrics();
            log.error("Circuit[{}]'s metrics:{},with param:{}", new Object[]{name, JsonUtil.toJson((Object)metrics), JsonUtil.toJson(model)});
        }
        return this.fallback(e.getCause());
    }

    protected ResultCode<O> fallback(Throwable e) {
        ServletRequestAttributes servletAttrs = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest req = servletAttrs.getRequest();
        String url = req.getRequestURI();
        String errCode = ErrCodeEnum.SERVER_ERROR.getCode();
        if (e instanceof CommonException) {
            errCode = ((CommonException)e).getErrCode().getCode();
        }
        ResultCode resultCode = ResultCode.error((String)errCode);
        log.error("[{}]circuit breaker result:{},with exception:{}", new Object[]{url, JsonUtil.toJson((Object)resultCode), e});
        return resultCode;
    }
}

