/*
 * Decompiled with CFR 0.152.
 */
package com.emc.documentum.springdata.core;

import com.documentum.fc.common.DfException;
import com.emc.documentum.springdata.core.DctmOperations;
import com.emc.documentum.springdata.entitymanager.EntityPersistenceManager;
import com.emc.documentum.springdata.entitymanager.EntityTypeHandler;
import com.emc.documentum.springdata.repository.query.DctmQuery;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.Assert;

@Controller
public class DctmTemplate
implements DctmOperations {
    private final EntityTypeHandler entityTypeManager;
    private final EntityPersistenceManager entityPersistenceManager;

    @Autowired
    public DctmTemplate(EntityPersistenceManager entityPersistenceManager, EntityTypeHandler entityTypeManager) {
        this.entityPersistenceManager = entityPersistenceManager;
        this.entityTypeManager = entityTypeManager;
    }

    @Override
    public <T> T create(T objectToSave) throws DfException {
        Assert.notNull(objectToSave);
        String repoObjectName = this.getRepositoryObjectName(objectToSave);
        return this.entityPersistenceManager.createObject(repoObjectName, objectToSave);
    }

    @Override
    public <T> String delete(T objectToDelete) throws DfException {
        Assert.notNull(objectToDelete);
        String repoObjectName = this.getRepositoryObjectName(objectToDelete);
        return this.entityPersistenceManager.deleteObject(repoObjectName, objectToDelete);
    }

    @Override
    public <ID> String deleteById(ID objectToDeleteId) throws DfException {
        Assert.notNull(objectToDeleteId);
        return this.entityPersistenceManager.deleteObject(objectToDeleteId.toString());
    }

    @Override
    public <T> List<T> findAll(Class<T> entityClass) throws DfException {
        return this.find(null, entityClass);
    }

    @Override
    public <T> List<T> find(DctmQuery query, Class<T> entityClass) throws DfException {
        Assert.notNull(entityClass);
        String repoObjectName = this.getRepositoryName(entityClass);
        return query == null ? this.doFindAll(entityClass, repoObjectName) : this.entityPersistenceManager.find(entityClass, repoObjectName, query);
    }

    private <T> List<T> doFindAll(Class<T> entityClass, String repoObjectName) throws DfException {
        return this.entityPersistenceManager.findAllObjects(entityClass, repoObjectName);
    }

    @Override
    public <T> T findById(String id, Class<T> entityClass) throws DfException {
        Assert.notNull((Object)id);
        Assert.notNull(entityClass);
        return this.entityPersistenceManager.findById(id, entityClass);
    }

    @Override
    public long count(Class<?> entityClass) throws DfException {
        Assert.notNull(entityClass);
        String repoObjectName = this.getRepositoryName(entityClass);
        return this.entityPersistenceManager.count(entityClass, repoObjectName);
    }

    @Override
    public <T> T update(T objectToUpdate) throws DfException {
        return this.entityPersistenceManager.update(objectToUpdate);
    }

    @Override
    public <T> String getRepositoryObjectName(T obj) {
        Assert.notNull(obj);
        return this.getRepositoryName(obj.getClass());
    }

    @Override
    public String getRepositoryName(Class<?> entityClass) {
        Assert.notNull(entityClass);
        return this.entityTypeManager.getEntityObjectName(entityClass);
    }

    @Override
    public <T> void setContent(T object, String contentType, String path) throws DfException {
        this.entityPersistenceManager.setContent(object, contentType, path);
    }

    @Override
    public <T> String getContent(T object, String path) throws DfException {
        return this.entityPersistenceManager.getContent(object, path);
    }
}

