/*
 * Decompiled with CFR 0.152.
 */
package com.emc.documentum.springdata.core;

import com.documentum.com.DfClientX;
import com.documentum.fc.client.IDfClient;
import com.documentum.fc.client.IDfSession;
import com.documentum.fc.client.IDfSessionManager;
import com.documentum.fc.client.IDfTypedObject;
import com.documentum.fc.common.DfException;
import com.documentum.fc.common.IDfLoginInfo;
import org.apache.log4j.Logger;
import org.springframework.data.authentication.UserCredentials;
import org.springframework.stereotype.Controller;
import org.springframework.util.Assert;

@Controller
public class Documentum {
    private Logger logger = Logger.getLogger(Documentum.class);
    private UserCredentials credentials;
    private String docBase;
    private IDfSessionManager sessionManager;

    public Documentum() {
    }

    public void setCredentials(UserCredentials credentials) {
        this.credentials = credentials;
    }

    public void setDocBase(String docBase) {
        this.docBase = docBase;
    }

    public UserCredentials getCredentials() {
        return this.credentials;
    }

    public Documentum(UserCredentials credentials, String docBase, String docbrokerHost, String docbrokerPort) throws DfException {
        Assert.notNull((Object)credentials);
        Assert.notNull((Object)docBase);
        this.credentials = credentials;
        this.docBase = docBase;
        this.createSessionManager(credentials, docbrokerHost, docbrokerPort);
    }

    private void createSessionManager(UserCredentials credentials, String docbrokerHost, String docbrokerPort) throws DfException {
        DfClientX clientX = new DfClientX();
        IDfClient client = clientX.getLocalClient();
        IDfTypedObject config = client.getClientConfig();
        if (docbrokerHost != null && docbrokerPort != null) {
            config.setString("primary_host", docbrokerHost);
            config.setInt("primary_port", new Integer(docbrokerPort).intValue());
        }
        this.sessionManager = client.newSessionManager();
        IDfLoginInfo loginInfo = clientX.getLoginInfo();
        loginInfo.setUser(credentials.getUsername());
        loginInfo.setPassword(credentials.getPassword());
        this.sessionManager.setIdentity("*", loginInfo);
        this.logger.info((Object)"Session Manager Created");
    }

    public IDfSession getSession() throws DfException {
        if (this.sessionManager == null) {
            this.logger.info((Object)"Creating session manager");
            this.createSessionManager(this.credentials, null, null);
            this.logger.info((Object)"Created session manager");
        }
        try {
            return this.sessionManager.getSession(this.docBase);
        }
        catch (Exception e) {
            String msg = String.format("Session cannot be instantiated for user %s for docBase %s. Exception: %s, %s.", this.credentials.getUsername(), this.docBase, e.getClass(), e.getMessage());
            this.logger.error((Object)msg);
            throw new DfException(msg, (Throwable)e);
        }
    }
}

