/*
 * Decompiled with CFR 0.152.
 */
package com.emc.documentum.springdata.entitymanager;

import com.documentum.fc.client.DfIdNotFoundException;
import com.documentum.fc.client.DfQuery;
import com.documentum.fc.client.IDfCollection;
import com.documentum.fc.client.IDfPersistentObject;
import com.documentum.fc.client.IDfSession;
import com.documentum.fc.client.IDfSysObject;
import com.documentum.fc.client.IDfTypedObject;
import com.documentum.fc.common.DfException;
import com.documentum.fc.common.DfId;
import com.documentum.fc.common.IDfId;
import com.emc.documentum.springdata.core.Documentum;
import com.emc.documentum.springdata.entitymanager.EntityTypeHandler;
import com.emc.documentum.springdata.entitymanager.attributes.AttributeType;
import com.emc.documentum.springdata.entitymanager.convert.DCTMToObjectConverter;
import com.emc.documentum.springdata.entitymanager.convert.ObjectToDCTMConverter;
import com.emc.documentum.springdata.entitymanager.mapping.MappingHandler;
import com.emc.documentum.springdata.repository.query.DctmQuery;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.beanutils.PropertyUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.annotation.Id;
import org.springframework.stereotype.Controller;
import org.springframework.util.ReflectionUtils;

@Controller
public class EntityPersistenceManager {
    public static final String SELECT_RELATION_QUERY = "select * from dm_relation where (relation_name='%s' and (parent_id='%s' and child_id='%s')) or (relation_name='%s' and (child_id = '%s' and parent_id = '%s'))";
    private Set objectsBeingSaved = new HashSet();
    private Set<String> objectsBeingUpdated = new HashSet<String>();
    private final Documentum documentum;
    private final MappingHandler mappingHandler;
    private final EntityTypeHandler entityTypeHandler;
    private final ObjectToDCTMConverter objectToDctmConverter;
    private final DCTMToObjectConverter DCTMToObjectConverter;

    @Autowired
    public EntityPersistenceManager(Documentum documentum, MappingHandler mappingHandler, EntityTypeHandler entityTypeHandler, ObjectToDCTMConverter objectToDctmConverter, DCTMToObjectConverter DCTMToObjectConverter2) {
        this.documentum = documentum;
        this.mappingHandler = mappingHandler;
        this.entityTypeHandler = entityTypeHandler;
        this.objectToDctmConverter = objectToDctmConverter;
        this.DCTMToObjectConverter = DCTMToObjectConverter2;
    }

    public <T> T createObject(String repoObjectName, T objectToSave) throws DfException {
        T createdObject = this.doCreateObject(repoObjectName, objectToSave);
        this.clearState();
        return createdObject;
    }

    private void clearState() {
        this.objectsBeingSaved = new HashSet();
        this.objectsBeingUpdated = new HashSet<String>();
    }

    private <T> T doCreateObject(String repoObjectName, T objectToSave) throws DfException {
        try {
            if (this.objectsBeingSaved.contains(objectToSave)) {
                T t = objectToSave;
                return t;
            }
            this.objectsBeingSaved.add(objectToSave);
            if (this.isIdAvailable(objectToSave)) {
                T t = this.doUpdate(objectToSave);
                return t;
            }
            T savedBaseObject = this.doSave(repoObjectName, objectToSave);
            HashSet<RelationshipInfo> relationshipMap = new HashSet<RelationshipInfo>();
            List<AttributeType> relations = this.mappingHandler.getRelations(objectToSave);
            for (AttributeType relation : relations) {
                this.saveRelatedObjects(objectToSave, relation, relationshipMap);
            }
            this.saveRelationship(relationshipMap);
            Iterator<AttributeType> iterator = savedBaseObject;
            return (T)iterator;
        }
        catch (Exception e) {
            throw new DfException((Throwable)e);
        }
        finally {
            this.objectsBeingSaved.remove(objectToSave);
        }
    }

    private <T> boolean isIdAvailable(T objectToSave) throws DfException {
        Field[] fields = this.mappingHandler.getFields(objectToSave.getClass());
        boolean isIdAvailable = false;
        for (Field field : fields) {
            field.setAccessible(true);
            if (field.getAnnotation(Id.class) == null) continue;
            isIdAvailable = ReflectionUtils.getField((Field)field, objectToSave) != null;
        }
        return isIdAvailable;
    }

    private void saveRelationship(Set<RelationshipInfo> relationshipMap) throws DfException {
        for (RelationshipInfo relationshipInfo : relationshipMap) {
            IDfSysObject parent = relationshipInfo.parentObject;
            parent.addChildRelative(relationshipInfo.relationshipName, relationshipInfo.childObject.getObjectId(), "", true, "");
        }
    }

    private <T> void saveRelatedObjects(T baseObject, AttributeType relationAttribute, Set<RelationshipInfo> relationships) throws DfException {
        try {
            Object relations = PropertyUtils.getProperty(baseObject, (String)relationAttribute.getFieldName());
            if (relations != null) {
                List<Object> relatedObjects = this.isCollection(relations) ? (List<Object>)relations : Collections.singletonList(relations);
                for (Object e : relatedObjects) {
                    if (e == null) continue;
                    Object relatedDctmObject = this.createObject(this.entityTypeHandler.getEntityObjectName(e.getClass()), e);
                    IDfSysObject parentDctmObject = this.getDctmObject(baseObject);
                    IDfSysObject childDctmObject = this.getDctmObject(relatedDctmObject);
                    relationships.add(new RelationshipInfo(relationAttribute.getRelationName(), parentDctmObject, childDctmObject));
                }
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new DfException((Throwable)e);
        }
    }

    private boolean isCollection(Object relations) {
        return Collection.class.isAssignableFrom(relations.getClass());
    }

    private <T> T doSave(String repoObjectName, T objectToSave) throws DfException {
        System.out.println("Saving object: " + objectToSave);
        try {
            IDfSysObject dctmObject = (IDfSysObject)this.documentum.getSession().newObject(repoObjectName);
            ArrayList<AttributeType> mapping = this.mappingHandler.getAttributeMappings(objectToSave);
            this.objectToDctmConverter.convert(objectToSave, dctmObject, mapping);
            dctmObject.save();
            String fieldName = this.mappingHandler.getIdField(objectToSave);
            PropertyUtils.setSimpleProperty(objectToSave, (String)fieldName, (Object)dctmObject.getObjectId().getId());
            return objectToSave;
        }
        catch (Exception e) {
            String msg = String.format("Object cannot be created for class %s. Exception: %s, %s.", objectToSave.getClass(), e.getClass(), e.getMessage());
            throw new DfException(msg, (Throwable)e);
        }
    }

    public <T> T update(T objectToUpdate) throws DfException {
        T updatedObject = this.doUpdate(objectToUpdate);
        this.clearState();
        return updatedObject;
    }

    private <T> T doUpdate(T objectToUpdate) throws DfException {
        try {
            String id = this.getId(objectToUpdate);
            if (this.objectsBeingUpdated.contains(id)) {
                return objectToUpdate;
            }
            this.objectsBeingUpdated.add(id);
            IDfSysObject dctmObject = this.getDctmObject(objectToUpdate);
            ArrayList<AttributeType> mapping = this.mappingHandler.getAttributeMappings(objectToUpdate);
            this.objectToDctmConverter.convert(objectToUpdate, dctmObject, mapping);
            dctmObject.save();
            this.updateRelatedObjects(objectToUpdate);
            this.DCTMToObjectConverter.convert((IDfTypedObject)dctmObject, objectToUpdate, mapping);
            return objectToUpdate;
        }
        catch (Exception e) {
            String msg = String.format("Object cannot be updated for class %s. Exception: %s, %s.", objectToUpdate.getClass(), e.getClass(), e.getMessage());
            throw new DfException(msg, (Throwable)e);
        }
    }

    private <T> void updateRelatedObjects(T dctmObject) throws DfException {
        List<AttributeType> relations = this.mappingHandler.getRelations(dctmObject);
        try {
            for (AttributeType relation : relations) {
                switch (relation.getRelationshipType()) {
                    case ONE_TO_MANY: {
                        this.updateChildren(dctmObject, relation);
                        break;
                    }
                    case ONE_TO_ONE: {
                        this.updateChild(dctmObject, relation);
                    }
                }
                PropertyUtils.getProperty(dctmObject, (String)relation.getFieldName());
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new DfException((Throwable)e);
        }
    }

    private <T> void updateChild(T dctmObject, AttributeType relation) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException, DfException {
        Object relatedObject = PropertyUtils.getProperty(dctmObject, (String)relation.getFieldName());
        if (relatedObject == null) {
            return;
        }
        this.createRelatedObject(relatedObject);
        this.createRelations(dctmObject, Collections.singletonList(this.getId(relatedObject)), relation.getRelationName());
    }

    private <T> void updateChildren(T dctmObject, AttributeType relation) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException, DfException {
        List relatedObjects = (List)PropertyUtils.getProperty(dctmObject, (String)relation.getFieldName());
        if (relatedObjects == null || relatedObjects.size() == 0) {
            return;
        }
        ArrayList<String> objectIdToRelate = new ArrayList<String>();
        for (Object relatedObject : relatedObjects) {
            this.createRelatedObject(relatedObject);
            objectIdToRelate.add(this.getId(relatedObject));
        }
        this.createRelations(dctmObject, objectIdToRelate, relation.getRelationName());
    }

    private void createRelatedObject(Object relatedObject) throws DfException {
        if (this.isIdAvailable(relatedObject)) {
            this.doUpdate(relatedObject);
        } else {
            this.createObject(this.entityTypeHandler.getEntityObjectName(relatedObject.getClass()), relatedObject);
        }
    }

    private <T> void createRelations(T dctmObject, List<String> objectIdToRelate, String relationName) throws DfException {
        String parentId = this.getId(dctmObject);
        for (String childId : objectIdToRelate) {
            if (this.isRelated(parentId, childId, relationName)) continue;
            IDfPersistentObject parentObject = this.documentum.getSession().getObject((IDfId)new DfId(parentId));
            parentObject.addChildRelative(relationName, (IDfId)new DfId(childId), "", true, "");
        }
    }

    private boolean isRelated(String parentId, String childId, String relationName) throws DfException {
        DfQuery query = new DfQuery();
        String queryString = String.format(SELECT_RELATION_QUERY, relationName, parentId, childId, relationName, parentId, childId);
        System.out.println(String.format("Executing relation query: \r\n %s", queryString));
        query.setDQL(queryString);
        IDfCollection relations = query.execute(this.documentum.getSession(), 0);
        return relations.next();
    }

    private <T> String getId(T objectToSave) throws DfException {
        Field[] fields = this.mappingHandler.getFields(objectToSave.getClass());
        String id = "";
        for (Field field : fields) {
            field.setAccessible(true);
            if (field.getAnnotation(Id.class) == null) continue;
            id = (String)ReflectionUtils.getField((Field)field, objectToSave);
        }
        return id;
    }

    public <T> String deleteObject(String repoObjectName, T objectToDelete) throws DfException {
        try {
            String idFieldName = this.mappingHandler.getIdField(objectToDelete);
            String id = (String)PropertyUtils.getSimpleProperty(objectToDelete, (String)idFieldName);
            return this.deleteObject(id);
        }
        catch (Exception e) {
            String msg = String.format("Object cannot be deleted of class %s. Exception: %s, %s.", objectToDelete.getClass(), e.getClass(), e.getMessage());
            throw new DfException(msg, (Throwable)e);
        }
    }

    public <T> String deleteObject(String id) throws DfException {
        try {
            IDfSession session = this.documentum.getSession();
            IDfPersistentObject dctmObjectToDelete = session.getObject((IDfId)new DfId(id));
            dctmObjectToDelete.destroy();
            return id;
        }
        catch (DfException e) {
            String msg = String.format("Object with id {%s} could not be deleted. Exception: %s, %s.", id, ((Object)((Object)e)).getClass(), e.getMessage());
            throw new DfException(msg, (Throwable)e);
        }
    }

    public <T> List<T> findAllObjects(Class<T> entityClass, String repoObjectName) throws DfException {
        try {
            IDfSession session = this.documentum.getSession();
            ArrayList<AttributeType> mapping = this.mappingHandler.getAttributeMappings(entityClass);
            ArrayList<T> list = new ArrayList<T>();
            DfQuery query = new DfQuery();
            String dql = "select * from " + repoObjectName;
            query.setDQL(dql);
            IDfCollection coll = query.execute(session, 0);
            while (coll.next()) {
                T objectInstance = entityClass.newInstance();
                IDfTypedObject dctmObject = coll.getTypedObject();
                this.DCTMToObjectConverter.convert(dctmObject, objectInstance, mapping);
                list.add(objectInstance);
            }
            return list;
        }
        catch (Exception e) {
            String msg = String.format("Objects cannot be found for class %s. Exception: %s, %s.", entityClass, e.getClass(), e.getMessage());
            throw new DfException(msg, (Throwable)e);
        }
    }

    public <T> List<T> find(Class<T> entityClass, String repoObjectName, DctmQuery dctmQuery) throws DfException {
        try {
            IDfSession session = this.documentum.getSession();
            ArrayList<AttributeType> mapping = this.mappingHandler.getAttributeMappings(entityClass);
            ArrayList<T> list = new ArrayList<T>();
            DfQuery query = new DfQuery();
            String dql = this.buildQuery(repoObjectName, dctmQuery);
            System.out.println("Executing query: " + dql);
            query.setDQL(dql);
            IDfCollection coll = query.execute(session, 0);
            while (coll.next()) {
                T objectInstance = entityClass.newInstance();
                IDfTypedObject dctmObject = coll.getTypedObject();
                this.DCTMToObjectConverter.convert(dctmObject, objectInstance, mapping);
                list.add(objectInstance);
            }
            return list;
        }
        catch (Exception e) {
            String msg = String.format("Objects cannot be found for class %s. Exception: %s, %s.", entityClass, e.getClass(), e.getMessage());
            throw new DfException(msg, (Throwable)e);
        }
    }

    private String buildQuery(String repoObjectName, DctmQuery dctmQuery) {
        String query = dctmQuery.isCompleteQuery() ? dctmQuery.getQueryString() : String.format("select * from %s where %s", repoObjectName, dctmQuery.getPredicate());
        return query;
    }

    public <T> T findById(String id, Class<T> entityClass) throws DfException {
        try {
            IDfSession session = this.documentum.getSession();
            ArrayList<AttributeType> mapping = this.mappingHandler.getAttributeMappings(entityClass);
            DfId dfid = new DfId(id);
            IDfSysObject dctmObject = (IDfSysObject)session.getObject((IDfId)dfid);
            T objectInstance = entityClass.newInstance();
            this.DCTMToObjectConverter.convert((IDfTypedObject)dctmObject, objectInstance, mapping);
            return objectInstance;
        }
        catch (DfIdNotFoundException dfId) {
            return null;
        }
        catch (Exception e) {
            String msg = String.format("Exception occurred for object with Id: %s class %s. Exception: %s, %s.", id, entityClass, e.getClass(), e.getMessage());
            throw new DfException(msg, (Throwable)e);
        }
    }

    public <T> void setContent(T object, String contentType, String path) throws DfException {
        try {
            IDfSysObject dctmObject = this.getDctmObject(object);
            dctmObject.setContentType(contentType);
            dctmObject.setFile(path);
            dctmObject.save();
        }
        catch (Exception e) {
            String msg = String.format("Object cannot be updated for class %s. Exception: %s, %s.", object.getClass(), e.getClass(), e.getMessage());
            throw new DfException(msg, (Throwable)e);
        }
    }

    public <T> String getContent(T object, String filePath) throws DfException {
        try {
            IDfSysObject dctmObject = this.getDctmObject(object);
            dctmObject.getFile(filePath);
            return filePath;
        }
        catch (Exception e) {
            String msg = String.format("Content cannot be fetched for class %s. Exception: %s, %s.", object.getClass(), e.getClass(), e.getMessage());
            throw new DfException(msg, (Throwable)e);
        }
    }

    private <T> IDfSysObject getDctmObject(T object) throws DfException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        String idField = this.mappingHandler.getIdField(object);
        Object valueFromClass = PropertyUtils.getSimpleProperty(object, (String)idField);
        DfId dfid = new DfId((String)valueFromClass);
        return (IDfSysObject)this.documentum.getSession().getObject((IDfId)dfid);
    }

    public long count(Class<?> entityClass, String repoObjectName) throws DfException {
        try {
            IDfSession session = this.documentum.getSession();
            DfQuery query = new DfQuery();
            String dql = "select count(*) as object_count from " + repoObjectName;
            query.setDQL(dql);
            IDfCollection coll = query.execute(session, 0);
            coll.next();
            return coll.getTypedObject().getLong("object_count");
        }
        catch (Exception e) {
            String msg = String.format("Objects count be found for class %s. Exception: %s, %s.", entityClass, e.getClass(), e.getMessage());
            throw new DfException(msg, (Throwable)e);
        }
    }

    private static final class RelationshipInfo {
        private final String relationshipName;
        private final IDfSysObject parentObject;
        private final IDfSysObject childObject;

        private RelationshipInfo(String relationshipName, IDfSysObject parentObject, IDfSysObject childObject) {
            this.relationshipName = relationshipName;
            this.parentObject = parentObject;
            this.childObject = childObject;
        }
    }
}

