/*
 * Decompiled with CFR 0.152.
 */
package com.emc.documentum.springdata.entitymanager.attributes;

import com.emc.documentum.springdata.entitymanager.annotations.Relation;
import com.emc.documentum.springdata.entitymanager.attributes.Attribute;
import com.emc.documentum.springdata.entitymanager.attributes.BooleanAttribute;
import com.emc.documentum.springdata.entitymanager.attributes.BooleanListAttribute;
import com.emc.documentum.springdata.entitymanager.attributes.DoubleAttribute;
import com.emc.documentum.springdata.entitymanager.attributes.DoubleListAttribute;
import com.emc.documentum.springdata.entitymanager.attributes.EntityAttribute;
import com.emc.documentum.springdata.entitymanager.attributes.EntityCollectionAttribute;
import com.emc.documentum.springdata.entitymanager.attributes.IntAttribute;
import com.emc.documentum.springdata.entitymanager.attributes.IntListAttribute;
import com.emc.documentum.springdata.entitymanager.attributes.LongAttribute;
import com.emc.documentum.springdata.entitymanager.attributes.LongListAttribute;
import com.emc.documentum.springdata.entitymanager.attributes.StringAttribute;
import com.emc.documentum.springdata.entitymanager.attributes.StringListAttribute;
import com.emc.documentum.springdata.entitymanager.attributes.TypeUtils;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public class AttributeFactory {
    public static Attribute<?> getAttribute(Field field, String attributeName) {
        Class<?> type = field.getType();
        if (AttributeFactory.isRelation(field)) {
            return AttributeFactory.getAttributeAsRelation(field, attributeName);
        }
        if (TypeUtils.isString(type)) {
            return new StringAttribute(attributeName);
        }
        if (TypeUtils.isInteger(type)) {
            return new IntAttribute(attributeName);
        }
        if (TypeUtils.isDouble(type)) {
            return new DoubleAttribute(attributeName);
        }
        if (TypeUtils.isLong(type)) {
            return new LongAttribute(attributeName);
        }
        if (TypeUtils.isBoolean(type)) {
            return new BooleanAttribute(attributeName);
        }
        if (TypeUtils.isCollection(type) && TypeUtils.isString(AttributeFactory.getParameterizedType(field))) {
            return new StringListAttribute(attributeName);
        }
        if (TypeUtils.isCollection(type) && TypeUtils.isInteger(AttributeFactory.getParameterizedType(field))) {
            return new IntListAttribute(attributeName);
        }
        if (TypeUtils.isCollection(type) && TypeUtils.isDouble(AttributeFactory.getParameterizedType(field))) {
            return new DoubleListAttribute(attributeName);
        }
        if (TypeUtils.isCollection(type) && TypeUtils.isLong(AttributeFactory.getParameterizedType(field))) {
            return new LongListAttribute(attributeName);
        }
        if (TypeUtils.isCollection(type) && TypeUtils.isBoolean(AttributeFactory.getParameterizedType(field))) {
            return new BooleanListAttribute(attributeName);
        }
        return null;
    }

    private static Attribute<?> getAttributeAsRelation(Field field, String attributeName) {
        if (TypeUtils.isCollection(field.getType())) {
            return new EntityCollectionAttribute(attributeName);
        }
        return new EntityAttribute(attributeName);
    }

    private static boolean isRelation(Field field) {
        return field.getAnnotation(Relation.class) != null;
    }

    private static Type getParameterizedType(Field field) {
        field.setAccessible(true);
        return ((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0];
    }
}

