/*
 * Decompiled with CFR 0.152.
 */
package com.emc.documentum.springdata.entitymanager.convert;

import com.documentum.fc.client.DfQuery;
import com.documentum.fc.client.IDfCollection;
import com.documentum.fc.client.IDfPersistentObject;
import com.documentum.fc.client.IDfTypedObject;
import com.documentum.fc.common.DfException;
import com.documentum.fc.common.DfId;
import com.documentum.fc.common.IDfId;
import com.emc.documentum.springdata.entitymanager.attributes.Attribute;
import com.emc.documentum.springdata.entitymanager.attributes.AttributeType;
import com.emc.documentum.springdata.entitymanager.mapping.MappingHandler;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.annotation.Id;
import org.springframework.stereotype.Controller;
import org.springframework.util.ReflectionUtils;

@Controller
public class DCTMToObjectConverter {
    public static final String SELECT_RELATION_QUERY = "select * from dm_relation where relation_name='%s' and (parent_id='%s' or child_id='%s')";
    @Autowired
    MappingHandler mappingHandler;
    private Map<String, Object> objectsBeingConverted = new HashMap<String, Object>();

    public void convert(IDfTypedObject dctmObject, Object objectToReturn, ArrayList<AttributeType> mapping) throws DfException {
        this.objectsBeingConverted = new HashMap<String, Object>();
        this.doConvert(dctmObject, objectToReturn, mapping);
    }

    private void doConvert(IDfTypedObject dctmObject, Object objectToReturn, ArrayList<AttributeType> mapping) throws DfException {
        this.setNonRelationalAttributes(dctmObject, objectToReturn, mapping);
        this.setRelationalAttributes(dctmObject, objectToReturn, mapping);
    }

    private void setNonRelationalAttributes(IDfTypedObject dctmObject, Object objectToReturn, ArrayList<AttributeType> mapping) throws DfException {
        for (AttributeType attributeType : mapping) {
            try {
                if (attributeType.isRelation()) continue;
                System.out.println(attributeType);
                this.getValue(dctmObject, objectToReturn, attributeType);
            }
            catch (Exception e) {
                String msg = String.format("Conversion failed for Object of class %s. Exception: %s, %s.", objectToReturn.getClass(), e.getClass(), e.getMessage());
                System.out.println("Failed for ");
                throw new DfException(msg, (Throwable)e);
            }
        }
    }

    private void setRelationalAttributes(IDfTypedObject dctmObject, Object objectToReturn, ArrayList<AttributeType> mapping) throws DfException {
        if (this.objectsBeingConverted.get(this.getId(objectToReturn)) == null) {
            this.objectsBeingConverted.put(this.getId(objectToReturn), objectToReturn);
        }
        for (AttributeType attributeType : mapping) {
            if (!attributeType.isRelation()) continue;
            this.populateRelatedObjects(dctmObject, objectToReturn, attributeType);
        }
    }

    private void populateRelatedObjects(IDfTypedObject dctmObject, Object objectToReturn, AttributeType attributeType) throws DfException {
        try {
            IDfCollection relations = this.getRelationObjects(dctmObject, attributeType);
            this.setRelatedObjects(dctmObject, objectToReturn, attributeType, relations);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new DfException((Throwable)e);
        }
    }

    private IDfCollection getRelationObjects(IDfTypedObject dctmObject, AttributeType attributeType) throws DfException {
        String objectId = dctmObject.getString("r_object_id");
        String relationQuery = String.format(SELECT_RELATION_QUERY, attributeType.getRelationName(), objectId, objectId);
        System.out.println(String.format("Executing query \r\n %s \r\n", relationQuery));
        DfQuery query = new DfQuery(relationQuery);
        return query.execute(dctmObject.getSession(), 0);
    }

    private void setRelatedObjects(IDfTypedObject dctmObject, Object objectToReturn, AttributeType attributeType, IDfCollection relations) throws DfException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        switch (attributeType.getRelationshipType()) {
            case ONE_TO_MANY: {
                this.setChildren(dctmObject, objectToReturn, attributeType, relations);
                break;
            }
            case ONE_TO_ONE: {
                this.setChild(dctmObject, objectToReturn, attributeType, relations);
            }
        }
    }

    private void setChild(IDfTypedObject dctmObject, Object objectToReturn, AttributeType attributeType, IDfCollection relation) throws DfException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (relation.next()) {
            String relatedObjectId;
            String string = relatedObjectId = this.getId(objectToReturn).equalsIgnoreCase(relation.getString("child_id")) ? relation.getString("parent_id") : relation.getString("child_id");
            if (this.objectsBeingConverted.get(relatedObjectId) == null) {
                IDfTypedObject child = relation.getTypedObject();
                IDfPersistentObject childObject = dctmObject.getSession().getObject((IDfId)new DfId(child.getString("child_id")));
                Object relatedEntityInstance = attributeType.getRelatedEntityClass().newInstance();
                this.doConvert((IDfTypedObject)childObject, relatedEntityInstance, this.mappingHandler.getAttributeMappings(relatedEntityInstance));
                PropertyUtils.setSimpleProperty((Object)objectToReturn, (String)attributeType.getFieldName(), relatedEntityInstance);
            } else {
                PropertyUtils.setSimpleProperty((Object)objectToReturn, (String)attributeType.getFieldName(), (Object)this.objectsBeingConverted.get(relatedObjectId));
            }
        }
    }

    private void setChildren(IDfTypedObject dctmObject, Object objectToReturn, AttributeType attributeType, IDfCollection relations) throws DfException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        ArrayList<Object> childrenList = new ArrayList<Object>();
        while (relations.next()) {
            String relatedObjectId;
            IDfTypedObject relation = relations.getTypedObject();
            String string = relatedObjectId = this.getId(objectToReturn).equalsIgnoreCase(relation.getString("child_id")) ? relation.getString("parent_id") : relation.getString("child_id");
            if (this.objectsBeingConverted.get(relatedObjectId) == null) {
                IDfPersistentObject childObject = dctmObject.getSession().getObject((IDfId)new DfId(relatedObjectId));
                String childObjectType = childObject.getString("r_object_type");
                System.out.println(String.format("Child object type: {%s}", childObjectType));
                Object relatedEntityInstance = attributeType.getRelatedEntityClass().newInstance();
                this.doConvert((IDfTypedObject)childObject, relatedEntityInstance, this.mappingHandler.getAttributeMappings(relatedEntityInstance));
                childrenList.add(relatedEntityInstance);
                this.objectsBeingConverted.put(relatedObjectId, relatedEntityInstance);
                continue;
            }
            childrenList.add(this.objectsBeingConverted.get(relatedObjectId));
        }
        PropertyUtils.setSimpleProperty((Object)objectToReturn, (String)attributeType.getFieldName(), childrenList);
    }

    private <T> String getId(T objectToSave) throws DfException {
        Field[] fields = this.mappingHandler.getFields(objectToSave.getClass());
        String id = "";
        for (Field field : fields) {
            field.setAccessible(true);
            if (field.getAnnotation(Id.class) == null) continue;
            id = (String)ReflectionUtils.getField((Field)field, objectToSave);
        }
        return id;
    }

    private void getValue(IDfTypedObject dctmObject, Object objectToReturn, AttributeType fieldType) throws DfException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Attribute<?> attribute = fieldType.getAttribute();
        Object attributeValue = attribute.getValue(dctmObject);
        PropertyUtils.setSimpleProperty((Object)objectToReturn, (String)fieldType.getFieldName(), attributeValue);
    }
}

