/*
 * Decompiled with CFR 0.152.
 */
package com.emc.documentum.springdata.entitymanager.convert;

import com.documentum.fc.client.IDfSysObject;
import com.documentum.fc.common.DfException;
import com.documentum.fc.common.DfValue;
import com.documentum.fc.common.IDfValue;
import com.emc.documentum.springdata.entitymanager.attributes.Attribute;
import com.emc.documentum.springdata.entitymanager.attributes.AttributeType;
import com.emc.documentum.springdata.entitymanager.attributes.IterableAttribute;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.springframework.stereotype.Controller;

@Controller
public class ObjectToDCTMConverter {
    public void convert(Object objectToSave, IDfSysObject dctmObject, ArrayList<AttributeType> mapping) throws DfException {
        for (AttributeType attributeType : mapping) {
            if (this.shouldIgnore(attributeType)) continue;
            try {
                this.setValue(dctmObject, objectToSave, attributeType);
            }
            catch (Exception e) {
                String msg = String.format("Conversion failed for Object of class %s. Exception: %s, %s.", objectToSave.getClass(), e.getClass(), e.getMessage());
                throw new DfException(msg, (Throwable)e);
            }
        }
    }

    private boolean shouldIgnore(AttributeType attributeType) {
        return attributeType.getAttribute().getName().equals("r_object_id") || attributeType.isRelation();
    }

    private void setValue(IDfSysObject dctmObject, Object objectToSave, AttributeType fieldType) throws DfException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object valueFromClass = PropertyUtils.getSimpleProperty((Object)objectToSave, (String)fieldType.getFieldName());
        if (valueFromClass != null) {
            Attribute<?> attribute = fieldType.getAttribute();
            if (attribute instanceof IterableAttribute) {
                ((IterableAttribute)attribute).setValue(dctmObject, (List)valueFromClass);
            } else {
                DfValue value = new DfValue(valueFromClass, fieldType.getAttribute().getDfAttributeType());
                dctmObject.setValue(fieldType.getAttribute().getName(), (IDfValue)value);
            }
        }
    }
}

