/*
 * Decompiled with CFR 0.152.
 */
package com.emc.documentum.springdata.entitymanager.mapping;

import com.documentum.fc.common.DfException;
import com.emc.documentum.springdata.core.GenericCache;
import com.emc.documentum.springdata.entitymanager.EntityTypeHandler;
import com.emc.documentum.springdata.entitymanager.annotations.Content;
import com.emc.documentum.springdata.entitymanager.annotations.Relation;
import com.emc.documentum.springdata.entitymanager.annotations.RelationshipType;
import com.emc.documentum.springdata.entitymanager.attributes.Attribute;
import com.emc.documentum.springdata.entitymanager.attributes.AttributeFactory;
import com.emc.documentum.springdata.entitymanager.attributes.AttributeType;
import com.emc.documentum.springdata.entitymanager.attributes.TypeUtils;
import com.emc.documentum.springdata.entitymanager.mapping.DctmAttribute;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.annotation.Id;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class MappingHandler {
    @Autowired
    private EntityTypeHandler typeHandler;
    private final GenericCache cache;
    private final GenericCache reverseCache;
    private final Set<Class<?>> initializingSet = new HashSet();

    public MappingHandler() {
        this.cache = new GenericCache();
        this.reverseCache = new GenericCache();
    }

    public <T> String getIdField(T objectOfEntityClass) throws DfException {
        return this.getIdField(objectOfEntityClass.getClass());
    }

    public String getIdField(Class<?> entityClass) throws DfException {
        Assert.notNull(entityClass, (String)"No class parameter provided, entity collection can't be determined!");
        if (this.cache.getEntry(entityClass) == null) {
            this.setAttributeMappingInCache(entityClass);
        }
        return this.getIDFromCache(entityClass);
    }

    private String getIDFromCache(Class<?> entityClass) {
        Assert.notNull(entityClass, (String)"No class parameter provided, entity collection can't be determined!");
        ArrayList mapping = (ArrayList)this.cache.getEntry(entityClass);
        for (AttributeType attributeType : mapping) {
            if (!attributeType.getAttribute().getName().equals("r_object_id")) continue;
            return attributeType.getFieldName();
        }
        return null;
    }

    public <T> ArrayList<AttributeType> getAttributeMappings(T objectOfEntityClass) throws DfException {
        return this.getAttributeMappings(objectOfEntityClass.getClass());
    }

    public ArrayList<AttributeType> getAttributeMappings(Class<?> entityClass) throws DfException {
        Assert.notNull(entityClass, (String)"No class parameter provided, entity collection can't be determined!");
        return this.cache.getEntry(entityClass) == null ? this.setAttributeMappingInCache(entityClass) : (ArrayList)this.cache.getEntry(entityClass);
    }

    private ArrayList<AttributeType> setAttributeMappingInCache(Class<?> entityClass) throws DfException {
        Field[] fields;
        this.initializingSet.add(entityClass);
        ArrayList<AttributeType> mapping = new ArrayList<AttributeType>();
        for (Field field : fields = this.getFields(entityClass)) {
            field.setAccessible(true);
            if (this.isContentAttribute(field)) continue;
            if (this.isRelation(field) && !this.initializingSet.contains(this.getRelatedEntityClass(field))) {
                this.getAttributeMappings(this.getRelatedEntityClass(field));
            }
            this.addMapping(mapping, field);
        }
        this.cache.setEntry(entityClass, mapping);
        this.reverseCache.setEntry(this.typeHandler.getEntityObjectName(entityClass), entityClass);
        this.initializingSet.remove(entityClass);
        return mapping;
    }

    public Class<?> getEntityClass(String repositoryEntityName) {
        return (Class)this.reverseCache.getEntry(repositoryEntityName);
    }

    public Field[] getFields(Class<?> entityClass) throws DfException {
        ArrayList<Field> fieldList = new ArrayList<Field>();
        for (Class<?> tmpClass = entityClass; tmpClass != null; tmpClass = tmpClass.getSuperclass()) {
            fieldList.addAll(Arrays.asList(tmpClass.getDeclaredFields()));
        }
        Field[] fields = new Field[fieldList.size()];
        if ((fields = fieldList.toArray(fields)).length == 0) {
            throw new DfException("No fields to map for the given class!");
        }
        return fields;
    }

    private void addMapping(ArrayList<AttributeType> mapping, Field f) {
        String attributeName = this.getEntityFieldName(f);
        Attribute<?> attribute = AttributeFactory.getAttribute(f, attributeName);
        AttributeType attributeType = new AttributeType(f.getName(), attribute, this.isRelation(f), this.isRelation(f) ? f.getAnnotation(Relation.class).name() : "", this.getRelationshipType(f), this.getRelatedEntityClass(f));
        mapping.add(attributeType);
    }

    private RelationshipType getRelationshipType(Field field) {
        return this.isRelation(field) ? field.getAnnotation(Relation.class).value() : null;
    }

    private Class<?> getRelatedEntityClass(Field field) {
        if (!this.isRelation(field)) {
            return null;
        }
        Class<?> fieldType = field.getType();
        Type type = TypeUtils.isCollection(fieldType) ? ((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0] : field.getGenericType();
        return (Class)type;
    }

    private boolean isRelation(Field f) {
        return f.getAnnotation(Relation.class) != null;
    }

    private boolean isContentAttribute(Field f) {
        return f.getAnnotation(Content.class) != null;
    }

    private String getEntityFieldName(Field f) {
        DctmAttribute dctmAttribute;
        String attributeName = f.isAnnotationPresent(Id.class) ? "r_object_id" : (f.isAnnotationPresent(DctmAttribute.class) ? ((dctmAttribute = f.getAnnotation(DctmAttribute.class)) == null ? f.getName() : dctmAttribute.value()) : f.getName());
        return attributeName;
    }

    public <T> List<AttributeType> getRelations(T objectToSave) throws DfException {
        ArrayList<AttributeType> attributeMappings = this.getAttributeMappings(objectToSave);
        ArrayList<AttributeType> relations = new ArrayList<AttributeType>();
        for (AttributeType attributeType : attributeMappings) {
            if (!attributeType.isRelation()) continue;
            relations.add(attributeType);
        }
        return relations;
    }
}

