/*
 * Decompiled with CFR 0.152.
 */
package com.emc.documentum.springdata.repository.query;

import com.emc.documentum.springdata.core.DctmOperations;
import com.emc.documentum.springdata.repository.query.DctmQuery;
import com.emc.documentum.springdata.repository.query.DctmQueryMethod;
import com.emc.documentum.springdata.repository.query.execution.CollectionExecution;
import com.emc.documentum.springdata.repository.query.execution.Execution;
import com.emc.documentum.springdata.repository.query.execution.ModifyingQuery;
import com.emc.documentum.springdata.repository.query.execution.SingleEntityExecution;
import org.springframework.data.repository.query.RepositoryQuery;

public abstract class AbstractDctmQuery
implements RepositoryQuery {
    protected final DctmOperations dctmOperations;
    protected final DctmQueryMethod queryMethod;

    public AbstractDctmQuery(DctmOperations dctmOperations, DctmQueryMethod queryMethod) {
        this.dctmOperations = dctmOperations;
        this.queryMethod = queryMethod;
    }

    public Object execute(Object[] parameters) {
        Execution execution = this.getExecution();
        DctmQuery query = this.createQuery(parameters);
        return execution.execute(query, this.dctmOperations, this.queryMethod.getEntityInformation().getJavaType());
    }

    protected abstract DctmQuery createQuery(Object[] var1);

    private Execution getExecution() {
        if (this.queryMethod.isCollectionQuery()) {
            return new CollectionExecution();
        }
        if (this.queryMethod.isModifyingQuery()) {
            return new ModifyingQuery();
        }
        return new SingleEntityExecution();
    }

    public DctmQueryMethod getQueryMethod() {
        return this.queryMethod;
    }
}

