/*
 * Decompiled with CFR 0.152.
 */
package com.emc.documentum.springdata.repository.query;

import com.documentum.fc.common.DfException;
import com.emc.documentum.springdata.entitymanager.attributes.AttributeType;
import com.emc.documentum.springdata.entitymanager.mapping.MappingHandler;
import com.emc.documentum.springdata.repository.query.DctmQuery;
import com.emc.documentum.springdata.repository.query.DctmQueryMethod;
import com.mysema.query.BooleanBuilder;
import com.mysema.query.types.ConstantImpl;
import com.mysema.query.types.Expression;
import com.mysema.query.types.Predicate;
import com.mysema.query.types.expr.BooleanOperation;
import com.mysema.query.types.path.PathBuilder;
import java.util.ArrayList;
import java.util.Iterator;
import org.springframework.data.domain.Sort;
import org.springframework.data.mapping.PropertyPath;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.parser.AbstractQueryCreator;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.data.repository.query.parser.PartTree;
import org.springframework.util.Assert;

public class DctmQueryCreator
extends AbstractQueryCreator<DctmQuery, Predicate> {
    private final PathBuilder pathBuilder;
    private final MappingHandler mappingHandler;
    private DctmQueryMethod queryMethod;

    public DctmQueryCreator(MappingHandler mappingHandler, PartTree tree, DctmQueryMethod queryMethod, ParameterAccessor accessor) {
        super(tree, accessor);
        this.mappingHandler = mappingHandler;
        this.queryMethod = queryMethod;
        this.pathBuilder = new PathBuilder(queryMethod.getEntityInformation().getJavaType(), queryMethod.getEntityInformation().getDctmEntityName());
    }

    protected Predicate create(Part part, Iterator<Object> iterator) {
        Object value = iterator.next();
        try {
            switch (part.getType()) {
                case SIMPLE_PROPERTY: {
                    if (part.getProperty().getType() == String.class) {
                        value = this.escape((String)value);
                    }
                    return this.pathBuilder.get(this.getDctmAttributeName(part), part.getProperty().getType()).eq(value);
                }
                case GREATER_THAN: {
                    return this.pathBuilder.getNumber(this.getDctmAttributeName(part), part.getProperty().getType()).gt((Expression)new ConstantImpl((Object)((Number)value)));
                }
            }
            throw new UnsupportedOperationException(String.format("Unidentifiable part of the query {%s}", part.getType().name()));
        }
        catch (DfException e) {
            e.printStackTrace();
            return null;
        }
    }

    private String getDctmAttributeName(Part part) throws DfException {
        ArrayList<AttributeType> attributeMappings = this.mappingHandler.getAttributeMappings(this.queryMethod.getEntityInformation().getJavaType());
        PropertyPath property = part.getProperty();
        for (AttributeType attributeMapping : attributeMappings) {
            if (!attributeMapping.getFieldName().equalsIgnoreCase(property.getSegment())) continue;
            return attributeMapping.getAttribute().getName();
        }
        return null;
    }

    private String escape(String property) {
        return "'" + property + "'";
    }

    protected Predicate and(Part part, Predicate base, Iterator<Object> iterator) {
        if (base == null) {
            return this.create(part, iterator);
        }
        Predicate right = this.create(part, iterator);
        return ((BooleanOperation)base).and(right);
    }

    protected Predicate or(Predicate base, Predicate criteria) {
        Assert.notNull((Object)base);
        Assert.notNull((Object)criteria);
        BooleanBuilder or = new BooleanBuilder(base).or(criteria);
        return or.getValue();
    }

    protected DctmQuery complete(Predicate criteria, Sort sort) {
        DctmQuery dctmQuery = new DctmQuery(criteria);
        return dctmQuery.with(sort);
    }
}

