/*
 * Decompiled with CFR 0.152.
 */
package com.emc.documentum.springdata.repository.query;

import com.emc.documentum.springdata.core.DctmOperations;
import com.emc.documentum.springdata.entitymanager.mapping.MappingHandler;
import com.emc.documentum.springdata.repository.query.AbstractDctmQuery;
import com.emc.documentum.springdata.repository.query.DctmQuery;
import com.emc.documentum.springdata.repository.query.DctmQueryCreator;
import com.emc.documentum.springdata.repository.query.DctmQueryMethod;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.ParametersParameterAccessor;
import org.springframework.data.repository.query.parser.PartTree;

public class PartTreeDctmQuery
extends AbstractDctmQuery {
    private final PartTree partTree;
    private final MappingHandler mappingHandler;

    public PartTreeDctmQuery(MappingHandler mappingHandler, DctmOperations dctmOperations, DctmQueryMethod queryMethod) {
        super(dctmOperations, queryMethod);
        this.mappingHandler = mappingHandler;
        String queryMethodName = queryMethod.getName();
        if (queryMethodName.equalsIgnoreCase("setContent") || queryMethodName.equalsIgnoreCase("getContent")) {
            queryMethodName = "content";
        }
        this.partTree = new PartTree(queryMethodName, queryMethod.getEntityInformation().getJavaType());
    }

    @Override
    public DctmQuery createQuery(Object[] parameters) {
        DctmQueryCreator queryCreator = new DctmQueryCreator(this.mappingHandler, this.partTree, this.getQueryMethod(), (ParameterAccessor)new ParametersParameterAccessor(this.getQueryMethod().getParameters(), parameters));
        return (DctmQuery)queryCreator.createQuery();
    }
}

