/*
 * Decompiled with CFR 0.152.
 */
package com.emc.documentum.springdata.repository.support;

import com.documentum.fc.common.DfException;
import com.emc.documentum.springdata.core.DctmOperations;
import com.emc.documentum.springdata.repository.query.DctmQueryMethod;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.RepositoryQuery;

public class DctmContentQuery
implements RepositoryQuery {
    private final DctmOperations dctmOperations;
    private final DctmQueryMethod queryMethod;
    ContentQueryType contentQueryType;

    public DctmContentQuery(DctmOperations dctmOperations, DctmQueryMethod queryMethod) {
        this.dctmOperations = dctmOperations;
        this.queryMethod = queryMethod;
        if (queryMethod.getName().equalsIgnoreCase("setcontent")) {
            this.contentQueryType = ContentQueryType.SET;
        } else if (queryMethod.getName().equalsIgnoreCase("getcontent")) {
            this.contentQueryType = ContentQueryType.GET;
        } else {
            throw new IllegalStateException();
        }
    }

    public Object execute(Object[] parameters) {
        try {
            switch (this.contentQueryType) {
                case GET: {
                    return this.dctmOperations.getContent(parameters[0], (String)parameters[1]);
                }
                case SET: {
                    this.dctmOperations.setContent(parameters[0], (String)parameters[1], (String)parameters[2]);
                    return "SAVED";
                }
            }
            throw new UnsupportedOperationException("Cannot possibly execute this query");
        }
        catch (DfException e) {
            e.printStackTrace();
            return null;
        }
    }

    public QueryMethod getQueryMethod() {
        return this.queryMethod;
    }

    private static enum ContentQueryType {
        GET,
        SET;

    }
}

