/*
 * Decompiled with CFR 0.152.
 */
package com.emc.documentum.springdata.repository.support;

import com.emc.documentum.springdata.repository.DctmRepositoryWithContent;
import com.emc.documentum.springdata.repository.support.DctmEntityInformation;
import com.emc.documentum.springdata.repository.support.DctmQueryLookupStrategy;
import com.emc.documentum.springdata.repository.support.QueryDslDctmRepository;
import com.emc.documentum.springdata.repository.support.QueryDslDctmRepositoryWithContent;
import com.emc.documentum.springdata.repository.support.SimpleDctmEntityInformation;
import com.emc.documentum.springdata.repository.support.SimpleDctmRepository;
import com.emc.documentum.springdata.repository.support.SimpleDctmRepositoryWithContent;
import java.io.Serializable;
import org.springframework.context.ApplicationContext;
import org.springframework.data.querydsl.QueryDslPredicateExecutor;
import org.springframework.data.querydsl.QueryDslUtils;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;
import org.springframework.data.repository.query.EvaluationContextProvider;
import org.springframework.data.repository.query.QueryLookupStrategy;

public class DctmRepositoryFactory
extends RepositoryFactorySupport {
    private final ApplicationContext applicationContext;

    public DctmRepositoryFactory(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public <T, ID extends Serializable> DctmEntityInformation<T, ID> getEntityInformation(Class<T> domainClass) {
        return new SimpleDctmEntityInformation(domainClass);
    }

    protected Object getTargetRepository(RepositoryMetadata metadata) {
        EntityInformation dctmEntityInformation = this.getEntityInformation(metadata.getDomainType());
        return this.getDctmRepository(metadata, (DctmEntityInformation<?, Serializable>)dctmEntityInformation);
    }

    private Object getDctmRepository(RepositoryMetadata metadata, DctmEntityInformation<?, Serializable> dctmEntityInformation) {
        Class repositoryInterface = metadata.getRepositoryInterface();
        if (DctmRepositoryFactory.isQueryDslRepository(repositoryInterface)) {
            return DctmRepositoryWithContent.class.isAssignableFrom(repositoryInterface) ? new QueryDslDctmRepositoryWithContent(dctmEntityInformation, this.applicationContext) : new QueryDslDctmRepository(dctmEntityInformation, this.applicationContext);
        }
        return DctmRepositoryWithContent.class.isAssignableFrom(repositoryInterface) ? new SimpleDctmRepositoryWithContent(dctmEntityInformation, this.applicationContext) : new SimpleDctmRepository(dctmEntityInformation, this.applicationContext);
    }

    protected Class<?> getRepositoryBaseClass(RepositoryMetadata metadata) {
        return DctmRepositoryFactory.isQueryDslRepository(metadata.getRepositoryInterface()) ? QueryDslDctmRepository.class : SimpleDctmRepository.class;
    }

    protected QueryLookupStrategy getQueryLookupStrategy(QueryLookupStrategy.Key key, EvaluationContextProvider evaluationContextProvider) {
        return (QueryLookupStrategy)this.applicationContext.getBean(DctmQueryLookupStrategy.class);
    }

    private static boolean isQueryDslRepository(Class<?> repositoryInterface) {
        return QueryDslUtils.QUERY_DSL_PRESENT && QueryDslPredicateExecutor.class.isAssignableFrom(repositoryInterface);
    }
}

