/*
 * Decompiled with CFR 0.152.
 */
package com.emc.documentum.springdata.repository.support;

import com.documentum.fc.common.DfException;
import com.emc.documentum.springdata.core.DctmOperations;
import com.emc.documentum.springdata.repository.DctmRepository;
import com.emc.documentum.springdata.repository.support.DctmEntityInformation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.springframework.context.ApplicationContext;

public class SimpleDctmRepository<T, ID extends Serializable>
implements DctmRepository<T, ID> {
    private Logger logger = Logger.getLogger(SimpleDctmRepository.class);
    protected DctmEntityInformation<T, ID> dctmEntityInformation;
    protected DctmOperations dctmTemplate;

    public SimpleDctmRepository(DctmEntityInformation<T, ID> dctmEntityInformation, ApplicationContext applicationContext) {
        this.dctmTemplate = (DctmOperations)applicationContext.getBean(DctmOperations.class);
        this.dctmEntityInformation = dctmEntityInformation;
    }

    @Override
    public <S extends T> S save(S entity) {
        S createdEntity = null;
        try {
            createdEntity = this.dctmTemplate.create(entity);
        }
        catch (DfException e) {
            e.printStackTrace();
        }
        return createdEntity;
    }

    @Override
    public <S extends T> Iterable<S> save(Iterable<S> entities) {
        ArrayList<S> retVal = new ArrayList<S>();
        for (S entity : entities) {
            retVal.add(this.save(entity));
        }
        return retVal;
    }

    @Override
    public T findOne(ID id) {
        T retVal = null;
        try {
            retVal = this.dctmTemplate.findById(id.toString(), this.dctmEntityInformation.getJavaType());
        }
        catch (DfException e) {
            e.printStackTrace();
        }
        return retVal;
    }

    @Override
    public boolean exists(ID id) {
        return this.findOne(id) != null;
    }

    @Override
    public Iterable<T> findAll() {
        List retVal = null;
        try {
            retVal = this.dctmTemplate.findAll(this.dctmEntityInformation.getJavaType());
        }
        catch (DfException e) {
            e.printStackTrace();
        }
        return retVal;
    }

    @Override
    public Iterable<T> findAll(Iterable<ID> ids) {
        ArrayList<T> foundObjects = new ArrayList<T>();
        for (Serializable id : ids) {
            T found = this.findOne(id);
            if (found == null) continue;
            foundObjects.add(found);
        }
        return foundObjects;
    }

    @Override
    public long count() {
        try {
            return this.dctmTemplate.count(this.dctmEntityInformation.getJavaType());
        }
        catch (DfException e) {
            e.printStackTrace();
            return 0L;
        }
    }

    @Override
    public void delete(ID id) {
        try {
            this.dctmTemplate.deleteById(id.toString());
        }
        catch (DfException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void delete(T entity) {
        try {
            this.dctmTemplate.delete(entity);
        }
        catch (DfException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void delete(Iterable<? extends T> entities) {
        for (T entity : entities) {
            try {
                this.dctmTemplate.delete(entity);
            }
            catch (DfException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void deleteAll() {
        throw new UnsupportedOperationException();
    }
}

