/*
 * Decompiled with CFR 0.152.
 */
package com.emc.documentum.springdata.security;

import com.documentum.fc.client.DfClient;
import com.documentum.fc.client.IDfDocbaseMap;
import com.documentum.fc.common.DfException;
import com.documentum.fc.common.DfLoginInfo;
import com.documentum.fc.common.IDfLoginInfo;
import com.emc.documentum.springdata.core.Documentum;
import java.io.IOException;
import java.util.ArrayList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.authentication.UserCredentials;
import org.springframework.security.authentication.AuthenticationCredentialsNotFoundException;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.InternalAuthenticationServiceException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.stereotype.Component;

@Component
public class DocumentumAuthenticationProvider
implements AuthenticationProvider {
    @Autowired
    Documentum documentum;

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        try {
            String username = authentication.getName();
            String docBase = this.getRepositoryName(username);
            String password = authentication.getCredentials().toString();
            this.authenticate(username, password, docBase);
            this.documentum.setCredentials(new UserCredentials(username, password));
            this.documentum.setDocBase(docBase);
            ArrayList<SimpleGrantedAuthority> grantedAuths = new ArrayList<SimpleGrantedAuthority>();
            grantedAuths.add(new SimpleGrantedAuthority("ROLE_USER"));
            return new UsernamePasswordAuthenticationToken((Object)username, (Object)password, grantedAuths);
        }
        catch (IOException e) {
            throw new InternalAuthenticationServiceException("Unable to Authenticate", (Throwable)e);
        }
        catch (DfException e) {
            throw new InternalAuthenticationServiceException("Unable to Authenticate", (Throwable)e);
        }
    }

    public boolean supports(Class<?> aClass) {
        return aClass.equals(UsernamePasswordAuthenticationToken.class);
    }

    private boolean authenticate(String username, String password, String docBase) throws IOException, DfException {
        DfLoginInfo loginInfo = new DfLoginInfo(username, password);
        DfClient client = new DfClient();
        client.authenticate(docBase, (IDfLoginInfo)loginInfo);
        return true;
    }

    private String getRepositoryName(String userName) throws DfException {
        if (userName.contains("@")) {
            return userName.substring(userName.indexOf(64), userName.length());
        }
        return this.getRepositoriesFromDocBroker();
    }

    private String getRepositoriesFromDocBroker() throws DfException {
        DfClient client = new DfClient();
        IDfDocbaseMap docbases = client.getDocbaseMap();
        if (docbases.getDocbaseCount() == 1) {
            return docbases.getDocbaseName(0);
        }
        throw new AuthenticationCredentialsNotFoundException("Docborker has more than one repository. Either specify the repo name in repository.property or append it with user like username@reponame");
    }
}

