/**
 * Copyright (c) 2021-Now http://faasadmin.com All rights reserved.
 * No deletion without permission, or be held responsible to law.
 */

package com.faasadmin.faas.services.lessee.convert.lessee;

import com.faasadmin.faas.services.lessee.dal.dataobject.lessee.SaasLesseeDO;
import com.faasadmin.faas.services.lessee.vo.lessee.SaasLesseeCreateReqVO;
import com.faasadmin.faas.services.lessee.vo.lessee.SaasLesseeExcelVO;
import com.faasadmin.faas.services.lessee.vo.lessee.SaasLesseeRespVO;
import com.faasadmin.faas.services.lessee.vo.lessee.SaasLesseeUpdateReqVO;
import com.faasadmin.framework.common.pojo.PageResult;
import org.mapstruct.Mapper;
import org.mapstruct.factory.Mappers;

import java.util.List;

/**
 * 租户 Convert
 *
 * @author mszf
 */
@Mapper
public interface SaasLesseeConvert {

    SaasLesseeConvert INSTANCE = Mappers.getMapper(SaasLesseeConvert.class);

    SaasLesseeDO convert(SaasLesseeCreateReqVO bean);

    SaasLesseeDO convert(SaasLesseeUpdateReqVO bean);

    SaasLesseeRespVO convert(SaasLesseeDO bean);

    List<SaasLesseeRespVO> convertList(List<SaasLesseeDO> list);

    PageResult<SaasLesseeRespVO> convertPage(PageResult<SaasLesseeDO> page);

    List<SaasLesseeExcelVO> convertList02(List<SaasLesseeDO> list);

}
