/**
 * Copyright (c) 2021-Now http://faasadmin.com All rights reserved.
 * No deletion without permission, or be held responsible to law.
 */

package com.faasadmin.faas.services.lessee.convert.module;

import com.faasadmin.faas.services.lessee.dal.dataobject.module.SaasModuleDO;
import com.faasadmin.faas.services.lessee.vo.module.SaasModuleCreateReqVO;
import com.faasadmin.faas.services.lessee.vo.module.SaasModuleExcelVO;
import com.faasadmin.faas.services.lessee.vo.module.SaasModuleRespVO;
import com.faasadmin.faas.services.lessee.vo.module.SaasModuleUpdateReqVO;
import com.faasadmin.framework.common.pojo.PageResult;
import org.mapstruct.Mapper;
import org.mapstruct.factory.Mappers;

import java.util.List;

/**
 * 模块 Convert
 *
 * @author mszf
 */
@Mapper
public interface SaasModuleConvert {

    SaasModuleConvert INSTANCE = Mappers.getMapper(SaasModuleConvert.class);

    SaasModuleDO convert(SaasModuleCreateReqVO bean);

    SaasModuleDO convert(SaasModuleUpdateReqVO bean);

    SaasModuleRespVO convert(SaasModuleDO bean);

    List<SaasModuleRespVO> convertList(List<SaasModuleDO> list);

    PageResult<SaasModuleRespVO> convertPage(PageResult<SaasModuleDO> page);

    List<SaasModuleExcelVO> convertList02(List<SaasModuleDO> list);

}
