/**
 * Copyright (c) 2021-Now http://faasadmin.com All rights reserved.
 * No deletion without permission, or be held responsible to law.
 */

package com.faasadmin.faas.services.lessee.dal.dataobject.module;

import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.faasadmin.framework.mybatis.plus.core.dataobject.BaseDO;
import lombok.*;

/**
 * 模块与菜单关联 DO
 *
 * @author mszf
 */
@TableName(value = "saas_module_menu",keepGlobalPrefix = true)
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class SaasModuleMenuDO extends BaseDO {

    /**
     * 主键
     */
    @TableId
    private Long id;
    /**
     * 模块ID
     */
    private Long moduleId;
    /**
     * 菜单ID
     */
    private Long menuId;

}
