/**
 * Copyright (c) 2021-Now http://faasadmin.com All rights reserved.
 * No deletion without permission, or be held responsible to law.
 */

package com.faasadmin.faas.services.lessee.enums.lessee;

/**
 * @version: V1.0
 * @author: mszf
 * @description: 租户是否初始化
 * @data: 2021-09-13 14:20
 **/
public enum LesseeInitEnums {

    NO("0", "未初始化"),
    YES("1", "已初始化"),
    ;

    private String id;
    private String name;

    LesseeInitEnums(String id, String name) {
        this.id = id;
        this.name = name;
    }

    public static String getName(String id) {
        for (LesseeInitEnums em : LesseeInitEnums.values()) {
            if (em.id.equals(id)) {
                return em.name;
            }
        }
        return null;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
}
