/**
 * Copyright (c) 2021-Now http://faasadmin.com All rights reserved.
 * No deletion without permission, or be held responsible to law.
 */

package com.faasadmin.faas.services.lessee.vo.lessee;

import com.faasadmin.faas.services.lessee.enums.lessee.LesseeInitEnums;
import com.faasadmin.framework.common.enums.CommonStatusEnum;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import javax.validation.constraints.NotNull;
import java.util.Date;

import static com.faasadmin.framework.common.utils.DateUtils.FORMAT_YEAR_MONTH_DAY_HOUR_MINUTE_SECOND;

/**
* 租户 Base VO，提供给添加、修改、详细的子 VO 使用
* 如果子 VO 存在差异的字段，请不要添加到这里，影响 Swagger 文档生成
*/
@Data
public class SaasLesseeBaseVO {

    @ApiModelProperty(value = "编码")
    private String code;

    @ApiModelProperty(value = "租户名称", required = true)
    @NotNull(message = "租户名称不能为空")
    private String name;

    @ApiModelProperty(value = "手机号", required = true)
    @NotNull(message = "手机号不能为空")
    private String mobile;

    /**
     * @see LesseeInitEnums
     */
    @ApiModelProperty(value = "租户类型", required = true)
    @NotNull(message = "租户类型不能为空")
    private String type;

    @ApiModelProperty(value = "登录密码", required = true)
    @NotNull(message = "登录密码不能为空")
    private String password;

    @ApiModelProperty(value = "登录账号", required = true)
    @NotNull(message = "登录账号不能为空")
    private String loginAccount;

    @ApiModelProperty(value = "到期日期 开始时间")
    @DateTimeFormat(pattern = FORMAT_YEAR_MONTH_DAY_HOUR_MINUTE_SECOND)
    private Date beginTime;

    @ApiModelProperty(value = "到期日期 结束时间")
    @DateTimeFormat(pattern = FORMAT_YEAR_MONTH_DAY_HOUR_MINUTE_SECOND)
    private Date endTime;

    /**
     * @see LesseeInitEnums
     */
    @ApiModelProperty(value = "是否初始化", required = true)
    @NotNull(message = "是否初始化不能为空")
    private String init;

    /**
     * @see CommonStatusEnum
     */
    @ApiModelProperty(value = "租户状态")
    private Integer status;

}
