/**
 * Copyright (c) 2021-Now http://faasadmin.com All rights reserved.
 * No deletion without permission, or be held responsible to law.
 */

package com.faasadmin.faas.services.lessee.vo.lesseeConfig;

import com.alibaba.fastjson.JSONObject;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;

/**
 * 租户json配置 Base VO，提供给添加、修改、详细的子 VO 使用
 * 如果子 VO 存在差异的字段，请不要添加到这里，影响 Swagger 文档生成
 */
@Data
public class SaasLesseeJsonConfigBaseVO {

    @ApiModelProperty(value = "租户ID", required = true)
    private Long lesseeId;

    @ApiModelProperty(value = "应用ID", required = true)
    private String appId;

    @ApiModelProperty(value = "配置名称", required = true)
    private String name;

    @ApiModelProperty(value = "配置键名", required = true)
    private String key;

    @ApiModelProperty(value = "配置键值", required = true)
    @NotNull(message = "配置键值不能为空")
    private JSONObject value;

    @ApiModelProperty(value = "备注")
    private String remark;

}
