/**
 * Copyright (c) 2021-Now http://faasadmin.com All rights reserved.
 * No deletion without permission, or be held responsible to law.
 */

package com.faasadmin.faas.services.lessee.vo.module;

import lombok.*;
import io.swagger.annotations.*;
import javax.validation.constraints.*;

/**
* 模块 Base VO，提供给添加、修改、详细的子 VO 使用
* 如果子 VO 存在差异的字段，请不要添加到这里，影响 Swagger 文档生成
*/
@Data
public class SaasModuleBaseVO {

    @ApiModelProperty(value = "模块名称", required = true)
    @NotNull(message = "模块名称不能为空")
    private String name;

    @ApiModelProperty(value = "模块类型")
    private String type;

    @ApiModelProperty(value = "模块状态")
    private String status;

    @ApiModelProperty(value = "模块排序", required = true)
    @NotNull(message = "模块排序不能为空")
    private Integer sort;

}
